/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAClientKeyExchangeParser<T extends RSAClientKeyExchangeMessage>
extends ClientKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RSAClientKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(T msg) {
        LOGGER.debug("Parsing RSAClientKeyExchangeMessage");
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
    }

    protected void parseRsaParams(T msg) {
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
    }

    private void parseSerializedPublicKeyLength(T msg) {
        if (this.getVersion().isSSL()) {
            ((ClientKeyExchangeMessage)msg).setPublicKeyLength(this.getBytesLeft());
        } else {
            ((ClientKeyExchangeMessage)msg).setPublicKeyLength(this.parseIntField(2));
        }
        LOGGER.debug("SerializedPublicKeyLength: {}", ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKey(this.parseByteArrayField((Integer)((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: {}", ((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
    }
}

