/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2MessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientHelloParser
extends SSL2MessageParser<SSL2ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ClientHelloParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SSL2ClientHelloMessage msg) {
        LOGGER.debug("Parsing SSL2ClientHello");
        this.parseProtocolVersion(msg);
        this.parseCipherSuiteLength(msg);
        this.parseSessionIDLength(msg);
        this.parseChallengeLength(msg);
        this.parseCipherSuites(msg);
        this.parseSessionID(msg);
        this.parseChallenge(msg);
    }

    private void parseProtocolVersion(SSL2ClientHelloMessage msg) {
        msg.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: {}", msg.getProtocolVersion().getValue());
    }

    private void parseCipherSuiteLength(SSL2ClientHelloMessage msg) {
        msg.setCipherSuiteLength(this.parseIntField(2));
        LOGGER.debug("CipherSuiteLength: {}", msg.getCipherSuiteLength().getValue());
    }

    private void parseSessionIDLength(SSL2ClientHelloMessage msg) {
        msg.setSessionIDLength(this.parseIntField(2));
        LOGGER.debug("SessionIDLength: {}", msg.getSessionIdLength().getValue());
    }

    private void parseChallengeLength(SSL2ClientHelloMessage msg) {
        msg.setChallengeLength(this.parseIntField(2));
        LOGGER.debug("ChallengeLength: {}", msg.getChallengeLength().getValue());
    }

    private void parseCipherSuites(SSL2ClientHelloMessage msg) {
        msg.setCipherSuites(this.parseByteArrayField((Integer)msg.getCipherSuiteLength().getValue()));
        LOGGER.debug("CipherSuites: {}", msg.getCipherSuites().getValue());
    }

    private void parseSessionID(SSL2ClientHelloMessage msg) {
        msg.setSessionID(this.parseByteArrayField((Integer)msg.getSessionIdLength().getValue()));
        LOGGER.debug("SessionID: {}", msg.getSessionId().getValue());
    }

    private void parseChallenge(SSL2ClientHelloMessage msg) {
        msg.setChallenge(this.parseByteArrayField((Integer)msg.getChallengeLength().getValue()));
        LOGGER.debug("Challenge: {}", msg.getChallenge().getValue());
    }
}

