/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SSL2MessageParser<T extends SSL2Message>
extends Parser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2MessageParser(InputStream stream, TlsContext tlsContext) {
        super(stream);
    }

    protected void parseMessageLength(T message) {
        int mask;
        byte[] length;
        byte[] firstTwoBytes = this.parseByteArrayField(2);
        if ((firstTwoBytes[0] & 0xFFFFFF80) != 0) {
            length = firstTwoBytes;
            mask = 63;
            ((SSL2Message)message).setPaddingLength(0);
        } else {
            length = DataConverter.concatenate((byte[][])new byte[][]{firstTwoBytes, this.parseByteArrayField(1)});
            mask = 127;
            ((SSL2Message)message).setPaddingLength(Integer.valueOf(length[2]));
        }
        int intLength = (length[0] & mask) << 8 | length[1] & 0xFF;
        ((SSL2Message)message).setMessageLength(intLength);
        LOGGER.debug("MessageLength: {}", ((SSL2Message)message).getMessageLength().getValue());
        ((SSL2Message)message).setCompleteResultingMessage(this.getAlreadyParsed());
    }

    protected void parseType(T msg) {
        ((SSL2Message)msg).setType(this.parseByteField(1));
        LOGGER.debug("Type: {}", ((SSL2Message)msg).getType().getValue());
    }
}

