/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpClientKeyExchangeParser
extends ClientKeyExchangeParser<SrpClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrpClientKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SrpClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing SRPClientKeyExchangeMessage");
        this.parsePublicKeyLength(msg);
        this.parsePublicKey(msg);
    }

    private void parsePublicKeyLength(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("PublicKeyLength: {}", msg.getPublicKeyLength().getValue());
    }

    private void parsePublicKey(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("PublicKey: {}", msg.getPublicKey().getValue());
    }
}

