/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpServerKeyExchangeParser
extends ServerKeyExchangeParser<SrpServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrpServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SrpServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing SRPServerKeyExchangeMessage");
        this.parseModulusLength(msg);
        this.parseModulus(msg);
        this.parseGeneratorLength(msg);
        this.parseGenerator(msg);
        this.parseSaltLength(msg);
        this.parseSalt(msg);
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
        if (this.isTLS12() || this.isDTLS12()) {
            this.parseSignatureAndHashAlgorithm(msg);
        }
        this.parseSignatureLength(msg);
        this.parseSignature(msg);
    }

    private void parseModulusLength(SrpServerKeyExchangeMessage msg) {
        msg.setModulusLength(this.parseIntField(2));
        LOGGER.debug("Modulus Length: {}", msg.getModulusLength().getValue());
    }

    private void parseModulus(SrpServerKeyExchangeMessage msg) {
        msg.setModulus(this.parseByteArrayField((Integer)msg.getModulusLength().getValue()));
        LOGGER.debug("Modulus: {}", (Object)Arrays.toString((byte[])msg.getModulus().getValue()));
    }

    private void parseSaltLength(SrpServerKeyExchangeMessage msg) {
        msg.setSaltLength(this.parseIntField(1));
        LOGGER.debug("Salt Length: {}", msg.getSaltLength().getValue());
    }

    private void parseSalt(SrpServerKeyExchangeMessage msg) {
        msg.setSalt(this.parseByteArrayField((Integer)msg.getSaltLength().getValue()));
        LOGGER.debug("Salt: {}", (Object)Arrays.toString((byte[])msg.getSalt().getValue()));
    }

    private void parseGeneratorLength(SrpServerKeyExchangeMessage msg) {
        msg.setGeneratorLength(this.parseIntField(2));
        LOGGER.debug("gLength: {}", msg.getGeneratorLength().getValue());
    }

    private void parseGenerator(SrpServerKeyExchangeMessage msg) {
        msg.setGenerator(this.parseByteArrayField((Integer)msg.getGeneratorLength().getValue()));
        LOGGER.debug("G: {}", (Object)Arrays.toString((byte[])msg.getGenerator().getValue()));
    }

    private void parseSerializedPublicKeyLength(SrpServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("SerializedPublicKeyLength: {}", msg.getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(SrpServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: {}", msg.getPublicKey().getValue());
    }

    private void parseSignatureAndHashAlgorithm(SrpServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureAndHashAlgorithm: {}", msg.getSignatureAndHashAlgorithm().getValue());
    }

    private void parseSignatureLength(SrpServerKeyExchangeMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: {}", msg.getSignatureLength().getValue());
    }

    private void parseSignature(SrpServerKeyExchangeMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("Signature: {}", msg.getSignature().getValue());
    }
}

