/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.cert;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionListParser;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.context.X509Context;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateEntryParser
extends Parser<CertificateEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext context;

    public CertificateEntryParser(InputStream stream, TlsContext context) {
        super(stream);
        this.context = context;
    }

    @Override
    public void parse(CertificateEntry entry) {
        LOGGER.debug("Parsing CertificatePair");
        this.parseCertificateLength(entry);
        this.parseCertificateBytes(entry);
        if (this.context.getChooser().getSelectedProtocolVersion().is13()) {
            this.parseExtensionsLength(entry);
            this.parseExtensionBytes(entry);
            this.parseExtensions(entry);
        }
    }

    private void parseCertificateLength(CertificateEntry pair) {
        pair.setCertificateLength(this.parseIntField(3));
        LOGGER.debug("CertificateLength: {}", pair.getCertificateLength().getValue());
    }

    private void parseCertificateBytes(CertificateEntry pair) {
        pair.setCertificateBytes(this.parseByteArrayField((Integer)pair.getCertificateLength().getValue()));
        LOGGER.debug("Certificate: {}", pair.getCertificateBytes().getValue());
    }

    private void parseExtensionsLength(CertificateEntry pair) {
        pair.setExtensionsLength(this.parseIntField(2));
        LOGGER.debug("ExtensionsLength: {}", pair.getExtensionsLength().getValue());
    }

    private void parseExtensionBytes(CertificateEntry pair) {
        pair.setExtensionBytes(this.parseByteArrayField((Integer)pair.getExtensionsLength().getValue()));
        LOGGER.debug("Extensions: {}", pair.getCertificateBytes().getValue());
    }

    private void parseExtensions(CertificateEntry pair) {
        ExtensionListParser parser = new ExtensionListParser(new ByteArrayInputStream((byte[])pair.getExtensionBytes().getValue()), this.context, false);
        LinkedList<ExtensionMessage> extensionMessages = new LinkedList<ExtensionMessage>();
        parser.parse((List<ExtensionMessage>)extensionMessages);
        pair.setExtensionList(extensionMessages);
    }

    public void parseX509Certificate(CertificateEntry entry) {
        try {
            this.context.resetTalkingX509Context();
            X509Context x509context = this.context.getTalkingX509Context();
            X509Certificate x509Certificate = new X509Certificate("certificate");
            X509Chooser x509Chooser = x509context.getChooser();
            x509Certificate.getParser(x509Chooser).parse(new BufferedInputStream(new ByteArrayInputStream((byte[])entry.getCertificateBytes().getValue())));
            entry.setX509certificate(x509Certificate);
        }
        catch (Exception E) {
            LOGGER.warn("Could not parse certificate bytes to X509Certificate", (Throwable)E);
        }
    }
}

