/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.cert;

import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.record.Record;
import java.io.InputStream;
import java.util.List;

public class CleanRecordByteSeperator
extends Parser<List<Record>> {
    private final int defaultMaxSize;
    private final boolean createRecordsDynamically;
    private boolean mustStillCoverEmptyMessageFromUpperLayer;

    public CleanRecordByteSeperator(int defaultMaxSize, InputStream stream, boolean createRecordsDynamically, boolean mustStillCoverEmptyMessageFromUpperLayer) {
        super(stream);
        this.defaultMaxSize = defaultMaxSize;
        this.createRecordsDynamically = createRecordsDynamically;
        this.mustStillCoverEmptyMessageFromUpperLayer = mustStillCoverEmptyMessageFromUpperLayer;
    }

    @Override
    public void parse(List<Record> records) {
        for (Record record : records) {
            Integer maxData = record.getMaxRecordLengthConfig();
            if (maxData == null) {
                maxData = this.defaultMaxSize;
            }
            record.setCleanProtocolMessageBytes(this.parseArrayOrTillEnd(maxData));
            this.mustStillCoverEmptyMessageFromUpperLayer = false;
        }
        if (this.createRecordsDynamically) {
            while (this.getBytesLeft() > 0 || this.mustStillCoverEmptyMessageFromUpperLayer) {
                Record record = new Record(this.defaultMaxSize);
                record.setCleanProtocolMessageBytes(this.parseArrayOrTillEnd(this.defaultMaxSize));
                records.add(record);
                this.mustStillCoverEmptyMessageFromUpperLayer = false;
            }
        }
    }
}

