/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientEsniInner;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerNamePairParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientEsniInnerParser
extends Parser<ClientEsniInner> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientEsniInner clientEsniInner = new ClientEsniInner();

    public ClientEsniInnerParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(ClientEsniInner esniInner) {
        this.parseClientNonce(this.clientEsniInner);
        this.parseServerNameListLength(this.clientEsniInner);
        this.parseServerNameListByte(this.clientEsniInner);
        this.parsePadding(this.clientEsniInner);
        this.parseServerNameList(this.clientEsniInner);
    }

    private void parseClientNonce(ClientEsniInner clientEsniInner) {
        byte[] clientNonce = this.parseByteArrayField(16);
        clientEsniInner.setClientNonce(clientNonce);
        LOGGER.debug("clientNonce: {}", clientEsniInner.getClientNonce().getValue());
    }

    private void parseServerNameListLength(ClientEsniInner clientEsniInner) {
        int serverNameListLength = this.parseIntField(2);
        clientEsniInner.setServerNameListLength(serverNameListLength);
        LOGGER.debug("serverNameListLength: {}", clientEsniInner.getServerNameListLength().getValue());
    }

    private void parseServerNameListByte(ClientEsniInner clientEsniInner) {
        byte[] serverNameListByte = this.parseByteArrayField((Integer)clientEsniInner.getServerNameListLength().getValue());
        clientEsniInner.setServerNameListBytes(serverNameListByte);
        LOGGER.debug("serverNameListByte: {}", clientEsniInner.getServerNameListBytes().getValue());
    }

    private void parsePadding(ClientEsniInner clientEsniInner) {
        byte[] padding = this.parseByteArrayField(this.getBytesLeft());
        clientEsniInner.setPadding(padding);
        LOGGER.debug("padding: {}", clientEsniInner.getPadding().getValue());
    }

    private void parseServerNameList(ClientEsniInner clientEsniInner) {
        LinkedList<ServerNamePair> serverNamePairList = new LinkedList<ServerNamePair>();
        ByteArrayInputStream innerStream = new ByteArrayInputStream((byte[])clientEsniInner.getServerNameListBytes().getValue());
        while (innerStream.available() > 0) {
            ServerNamePairParser parser = new ServerNamePairParser(innerStream);
            ServerNamePair pair = new ServerNamePair();
            parser.parse(pair);
            serverNamePairList.add(pair);
        }
        clientEsniInner.setServerNameList(serverNamePairList);
    }
}

