/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ConnectionIdExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionIdExtensionParser
extends ExtensionParser<ConnectionIdExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ConnectionIdExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(ConnectionIdExtensionMessage connectionIdExtensionMessage) {
        LOGGER.debug("Parsing ConnectionIdExtensionMessage");
        this.parseConnectionIdLength(connectionIdExtensionMessage);
        this.parseConnectionId(connectionIdExtensionMessage);
    }

    private void parseConnectionIdLength(ConnectionIdExtensionMessage msg) {
        msg.setConnectionIdLength(this.parseIntField(1));
        LOGGER.debug("ConnectionId length: {}", msg.getConnectionIdLength().getValue());
    }

    private void parseConnectionId(ConnectionIdExtensionMessage msg) {
        msg.setConnectionId(this.parseByteArrayField((Integer)msg.getConnectionIdLength().getValue()));
        LOGGER.debug("ConnectionId: {}", msg.getConnectionId().getValue());
    }
}

