/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECPointFormatExtensionParser
extends ExtensionParser<ECPointFormatExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECPointFormatExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(ECPointFormatExtensionMessage msg) {
        LOGGER.debug("Parsing ECPointFormatExtensionMessage");
        this.parsePointFormatsLength(msg);
        this.parsePointFormat(msg);
    }

    private void parsePointFormatsLength(ECPointFormatExtensionMessage msg) {
        msg.setPointFormatsLength(this.parseIntField(1));
        LOGGER.debug("PointFormatsLength: {}", msg.getPointFormatsLength().getValue());
    }

    private void parsePointFormat(ECPointFormatExtensionMessage msg) {
        msg.setPointFormats(this.parseByteArrayField((Integer)msg.getPointFormatsLength().getValue()));
        LOGGER.debug("PointFormats: {}", msg.getPointFormats().getValue());
    }
}

