/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EarlyDataExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EarlyDataExtensionParser
extends ExtensionParser<EarlyDataExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EarlyDataExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(EarlyDataExtensionMessage msg) {
        LOGGER.debug("Parsing EarlyDataExtensionMessage");
        if (this.getTlsContext().getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.parseMaxEarlyDataSize(msg);
        }
    }

    private void parseMaxEarlyDataSize(EarlyDataExtensionMessage msg) {
        msg.setMaxEarlyDataSize(this.parseIntField(4));
        LOGGER.debug("MaxEarlyDataSize: {}", msg.getMaxEarlyDataSize().getValue());
    }
}

