/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurvesExtensionParser
extends ExtensionParser<EllipticCurvesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EllipticCurvesExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(EllipticCurvesExtensionMessage msg) {
        LOGGER.debug("Parsing EllipticCurvesExtensionMessage");
        this.parseSupportedGroupsLength(msg);
        this.parseSupportedGroups(msg);
    }

    private void parseSupportedGroupsLength(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroupsLength(this.parseIntField(2));
        LOGGER.debug("SupportedGroupsLength: {}", msg.getSupportedGroupsLength().getValue());
    }

    private void parseSupportedGroups(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroups(this.parseByteArrayField((Integer)msg.getSupportedGroupsLength().getValue()));
        LOGGER.debug("SupportedGroups: {}", msg.getSupportedGroups().getValue());
    }
}

