/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.KeyShareEntryParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedServerNameIndicationExtensionParser
extends ExtensionParser<EncryptedServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConnectionEndType talkingConnectionEnd;

    public EncryptedServerNameIndicationExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
        this.talkingConnectionEnd = tlsContext.getTalkingConnectionEndType();
    }

    @Override
    public void parse(EncryptedServerNameIndicationExtensionMessage msg) {
        if (this.getBytesLeft() == 0) {
            LOGGER.debug("Received empty ESNI Extension");
            return;
        }
        if (this.talkingConnectionEnd == ConnectionEndType.SERVER) {
            this.parseNonce(msg);
        } else {
            this.parseCipherSuite(msg);
            this.parseKeyShareEntry(msg);
            this.parseRecordDigestLength(msg);
            this.parseRecordDigest(msg);
            this.parseEncryptedSniLength(msg);
            this.parseEncryptedSni(msg);
        }
    }

    private void parseNonce(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] nonce = this.parseByteArrayField(16);
        msg.setServerNonce(nonce);
        LOGGER.info("Received Nonce: {}", (Object)nonce);
    }

    private void parseCipherSuite(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] cipherSuite = this.parseByteArrayField(2);
        msg.setCipherSuite(cipherSuite);
        LOGGER.debug("cipherSuite: {}", msg.getCipherSuite().getValue());
    }

    private void parseKeyShareEntry(EncryptedServerNameIndicationExtensionMessage msg) {
        KeyShareEntryParser parser = new KeyShareEntryParser(this.getStream(), false);
        KeyShareEntry keyShareEntry = new KeyShareEntry();
        parser.parse(keyShareEntry);
        msg.setKeyShareEntry(keyShareEntry);
    }

    private void parseRecordDigestLength(EncryptedServerNameIndicationExtensionMessage msg) {
        int digestLen = this.parseIntField(2);
        msg.setRecordDigestLength(digestLen);
        LOGGER.debug("recordDigestLength: {}", msg.getRecordDigestLength().getValue());
    }

    private void parseRecordDigest(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] recordDigest = this.parseByteArrayField((Integer)msg.getRecordDigestLength().getValue());
        msg.setRecordDigest(recordDigest);
        LOGGER.debug("recordDigest: {}", msg.getRecordDigest().getValue());
    }

    private void parseEncryptedSniLength(EncryptedServerNameIndicationExtensionMessage msg) {
        int encryptedSniLength = this.parseIntField(2);
        msg.setEncryptedSniLength(encryptedSniLength);
        LOGGER.debug("encryptedSniLength: {}", (Object)msg.getEncryptedSniLength());
    }

    private void parseEncryptedSni(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] encryptedSni = this.parseByteArrayField(msg.getEncryptedSniLength().getOriginalValue());
        msg.setEncryptedSni(encryptedSni);
        LOGGER.debug("encryptedSni: {}", msg.getEncryptedSni().getValue());
    }
}

