/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EsniKeyRecord;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionListParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsniKeyRecordParser
extends Parser<EsniKeyRecord> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext tlsContext;

    public EsniKeyRecordParser(InputStream stream, TlsContext tlsContext) {
        super(stream);
        this.tlsContext = tlsContext;
    }

    @Override
    public void parse(EsniKeyRecord record) {
        this.parseVersion(record);
        switch (record.getVersion()) {
            case FF01: {
                this.parseChecksum(record);
                this.parseKeys(record);
                this.parseCipherSuites(record);
                this.parsePaddedLength(record);
                this.parseNotBefore(record);
                this.parseNotAfter(record);
                this.parseExtensions(record);
                break;
            }
            case FF02: {
                this.parseChecksum(record);
                this.parsePublicName(record);
                this.parseKeys(record);
                this.parseCipherSuites(record);
                this.parsePaddedLength(record);
                this.parseNotBefore(record);
                this.parseNotAfter(record);
                this.parseExtensions(record);
                break;
            }
            case FF03: {
                this.parsePublicName(record);
                this.parseKeys(record);
                this.parseCipherSuites(record);
                this.parsePaddedLength(record);
                this.parseExtensions(record);
                break;
            }
            default: {
                LOGGER.warn("Unknown version: {}, not parsing", (Object)record.getVersion());
            }
        }
    }

    private void parseVersion(EsniKeyRecord record) {
        byte[] version = this.parseByteArrayField(2);
        record.setVersion(EsniDnsKeyRecordVersion.getEnumByByte(version));
        LOGGER.debug("Version: {}", (Object)record.getVersion());
    }

    private void parseChecksum(EsniKeyRecord record) {
        byte[] checksum = this.parseByteArrayField(4);
        record.setChecksum(checksum);
        LOGGER.debug("Checksum: {}", (Object)record.getChecksum());
    }

    private void parsePublicName(EsniKeyRecord record) {
        byte[] publicNameLen = this.parseByteArrayField(2);
        record.setPublicNameLength(publicNameLen);
        byte[] publicName = this.parseByteArrayField(DataConverter.bytesToInt((byte[])publicNameLen));
        record.setPublicName(publicName);
        LOGGER.debug("Public Name Length: {}", (Object)DataConverter.bytesToInt((byte[])publicNameLen));
        LOGGER.debug("Public Name: {}", (Object)Arrays.toString(record.getPublicName()));
    }

    private void parseKeys(EsniKeyRecord record) {
        int keyExchangeLen;
        byte[] keysLen = this.parseByteArrayField(2);
        record.setKeysLength(keysLen);
        LOGGER.debug("KeysLength: {}", (Object)DataConverter.bytesToInt((byte[])keysLen));
        for (int i = 0; i < DataConverter.bytesToInt((byte[])keysLen); i += 4 + keyExchangeLen) {
            byte[] namedGroup = this.parseByteArrayField(2);
            keyExchangeLen = this.parseIntField(2);
            byte[] keyExchange = this.parseByteArrayField(keyExchangeLen);
            KeyShareStoreEntry entry = new KeyShareStoreEntry();
            entry.setGroup(NamedGroup.getNamedGroup(namedGroup));
            entry.setPublicKey(keyExchange);
            record.getKeys().add(entry);
            LOGGER.debug("namedGroup: {}", (Object)namedGroup);
            LOGGER.debug("keyExchange: {}", (Object)keyExchange);
        }
    }

    private void parseCipherSuites(EsniKeyRecord record) {
        byte[] cipherSuitesLen = this.parseByteArrayField(2);
        record.setCipherSuitesLength(cipherSuitesLen);
        LOGGER.debug("CipherSuitesLength: {}", (Object)DataConverter.bytesToInt((byte[])cipherSuitesLen));
        byte[] cipherSuitesBytes = this.parseByteArrayField(DataConverter.bytesToInt((byte[])cipherSuitesLen));
        List<CipherSuite> cipherSuites = CipherSuite.getCipherSuites(cipherSuitesBytes);
        record.setCipherSuiteList(cipherSuites);
    }

    private void parsePaddedLength(EsniKeyRecord record) {
        int paddedLength = this.parseIntField(2);
        record.setPaddedLength(paddedLength);
        LOGGER.debug("paddedLen: {}", (Object)record.getPaddedLength());
    }

    private void parseNotBefore(EsniKeyRecord record) {
        byte[] notBefore = this.parseByteArrayField(8);
        record.setNotBefore(DataConverter.bytesToLong((byte[])notBefore));
        LOGGER.debug("notBefore: {}", (Object)record.getNotBefore());
    }

    private void parseNotAfter(EsniKeyRecord record) {
        byte[] notAfter = this.parseByteArrayField(8);
        record.setNotAfter(DataConverter.bytesToLong((byte[])notAfter));
        LOGGER.debug("notAfter: {}", (Object)record.getNotAfter());
    }

    private void parseExtensions(EsniKeyRecord record) {
        byte[] extensionsLengthBytes = this.parseByteArrayField(2);
        record.setExtensionsLength(extensionsLengthBytes);
        LOGGER.debug("ExtensionsLength: {}", (Object)DataConverter.bytesToInt((byte[])extensionsLengthBytes));
        int extensionsLength = DataConverter.bytesToInt((byte[])extensionsLengthBytes);
        byte[] extensionListBytes = this.parseByteArrayField(extensionsLength);
        ExtensionListParser extensionListParser = new ExtensionListParser(new ByteArrayInputStream(extensionListBytes), this.tlsContext, false);
        LinkedList<ExtensionMessage> extensionList = new LinkedList<ExtensionMessage>();
        extensionListParser.parse((List<ExtensionMessage>)extensionList);
        record.setExtensions(extensionList);
    }
}

