/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionFactory;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.KeyShareExtensionParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtensionListParser
extends Parser<List<ExtensionMessage>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext tlsContext;
    private final boolean helloRetryRequestHint;

    public ExtensionListParser(InputStream stream, TlsContext tlsContext, boolean helloRetryRequestHint) {
        super(stream);
        this.tlsContext = tlsContext;
        this.helloRetryRequestHint = helloRetryRequestHint;
    }

    @Override
    public void parse(List<ExtensionMessage> extensionList) {
        while (this.getBytesLeft() > 0) {
            byte[] typeBytes = this.parseByteArrayField(2);
            ExtensionType extensionType = ExtensionType.getExtensionType(typeBytes);
            LOGGER.debug("ExtensionType: {} ({})", (Object)typeBytes, (Object)extensionType);
            int length = this.parseExtensionLength();
            byte[] extensionPayload = this.parseByteArrayField(length);
            ExtensionMessage extension = ExtensionFactory.getExtension(extensionType);
            extension.setExtensionType(typeBytes);
            extension.setExtensionLength(length);
            extension.setExtensionContent(extensionPayload);
            extension.setExtensionBytes(DataConverter.concatenate((byte[][])new byte[][]{typeBytes, DataConverter.intToBytes((int)length, (int)2), extensionPayload}));
            Parser parser = extension.getParser(this.tlsContext.getContext(), new ByteArrayInputStream(extensionPayload));
            if (parser instanceof KeyShareExtensionParser) {
                ((KeyShareExtensionParser)parser).setHelloRetryRequestHint(this.helloRetryRequestHint);
            }
            parser.parse(extension);
            extensionList.add(extension);
        }
    }

    private int parseExtensionLength() {
        int length = this.parseIntField(2);
        LOGGER.debug("ExtensionLength: {}", (Object)length);
        return length;
    }
}

