/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKBinderParser
extends Parser<PSKBinder> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PSKBinderParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(PSKBinder pskBinder) {
        LOGGER.debug("Parsing PSKBinder");
        this.parseBinderLength(pskBinder);
        this.parseBinderEntry(pskBinder);
    }

    private void parseBinderLength(PSKBinder pskBinder) {
        pskBinder.setBinderEntryLength(this.parseIntField(1));
        LOGGER.debug("Binder length:: {}", pskBinder.getBinderEntryLength().getValue());
    }

    private void parseBinderEntry(PSKBinder pskBinder) {
        pskBinder.setBinderEntry(this.parseByteArrayField((Integer)pskBinder.getBinderEntryLength().getValue()));
        LOGGER.debug("Parsed binder: {}", pskBinder.getBinderEntry().getValue());
    }
}

