/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKIdentityParser
extends Parser<PSKIdentity> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PSKIdentityParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(PSKIdentity pskIdentity) {
        LOGGER.debug("Parsing PSKIdentity");
        this.parseIdentityLength(pskIdentity);
        this.parseIdentity(pskIdentity);
        this.parseObfuscatedTicketAge(pskIdentity);
    }

    private void parseIdentityLength(PSKIdentity pskIdentity) {
        pskIdentity.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("Identity length:: {}", pskIdentity.getIdentityLength().getValue());
    }

    private void parseIdentity(PSKIdentity pskIdentity) {
        pskIdentity.setIdentity(this.parseByteArrayField((Integer)pskIdentity.getIdentityLength().getValue()));
        LOGGER.debug("Identity: {}", pskIdentity.getIdentity().getValue());
    }

    private void parseObfuscatedTicketAge(PSKIdentity pskIdentity) {
        pskIdentity.setObfuscatedTicketAge(this.parseByteArrayField(4));
        LOGGER.debug("Obfuscated ticket age: {}", pskIdentity.getObfuscatedTicketAge().getValue());
    }
}

