/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDClearExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDClearExtensionParser
extends ExtensionParser<PWDClearExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PWDClearExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PWDClearExtensionMessage msg) {
        LOGGER.debug("Parsing PWDClearExtensionMessage");
        this.parseUsernameLength(msg);
        this.parseUsername(msg);
    }

    private void parseUsernameLength(PWDClearExtensionMessage msg) {
        msg.setUsernameLength(this.parseIntField(1));
        LOGGER.debug("UsernameLength: {}", msg.getUsernameLength().getValue());
    }

    private void parseUsername(PWDClearExtensionMessage msg) {
        msg.setUsername(new String(this.parseByteArrayField((Integer)msg.getUsernameLength().getValue()), StandardCharsets.ISO_8859_1));
        LOGGER.debug("Username: {}", msg.getUsername().getValue());
    }
}

