/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PSKBinderParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PSKIdentityParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreSharedKeyExtensionParser
extends ExtensionParser<PreSharedKeyExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConnectionEndType talkingConnectionEndType;

    public PreSharedKeyExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
        this.talkingConnectionEndType = tlsContext.getTalkingConnectionEndType();
    }

    @Override
    public void parse(PreSharedKeyExtensionMessage msg) {
        LOGGER.debug("Parsing PreSharedKeyExtensionMessage");
        if (this.talkingConnectionEndType == ConnectionEndType.CLIENT) {
            this.parsePreSharedKeyIdentityListLength(msg);
            this.parsePreSharedKeyIdentityListBytes(msg);
            this.parsePreSharedKeyBinderListLength(msg);
            this.parsePreSharedKeyBinderListBytes(msg);
        } else {
            this.parseSelectedIdentity(msg);
        }
    }

    private void parsePreSharedKeyIdentityListLength(PreSharedKeyExtensionMessage msg) {
        msg.setIdentityListLength(this.parseIntField(2));
        LOGGER.debug("PreSharedKeyIdentityListLength: {}", msg.getIdentityListLength().getValue());
    }

    private void parsePreSharedKeyIdentityListBytes(PreSharedKeyExtensionMessage msg) {
        msg.setIdentityListBytes(this.parseByteArrayField((Integer)msg.getIdentityListLength().getValue()));
        LOGGER.debug("Identity list bytes: {}", msg.getIdentityListBytes().getValue());
        LinkedList<PSKIdentity> identities = new LinkedList<PSKIdentity>();
        ByteArrayInputStream innerStream = new ByteArrayInputStream((byte[])msg.getIdentityListBytes().getValue());
        while (innerStream.available() > 0) {
            PSKIdentityParser parser = new PSKIdentityParser(innerStream);
            PSKIdentity identity = new PSKIdentity();
            parser.parse(identity);
            identities.add(identity);
        }
        msg.setIdentities(identities);
    }

    private void parsePreSharedKeyBinderListLength(PreSharedKeyExtensionMessage msg) {
        msg.setBinderListLength(this.parseIntField(2));
        LOGGER.debug("PreSharedKeyBinderListLength: {}", msg.getBinderListLength().getValue());
    }

    private void parsePreSharedKeyBinderListBytes(PreSharedKeyExtensionMessage msg) {
        msg.setBinderListBytes(this.parseByteArrayField((Integer)msg.getBinderListLength().getValue()));
        LOGGER.debug("Binder list bytes: {}", msg.getBinderListBytes().getValue());
        LinkedList<PSKBinder> binders = new LinkedList<PSKBinder>();
        ByteArrayInputStream innerStream = new ByteArrayInputStream((byte[])msg.getBinderListBytes().getValue());
        while (innerStream.available() > 0) {
            PSKBinderParser parser = new PSKBinderParser(innerStream);
            PSKBinder binder = new PSKBinder();
            parser.parse(binder);
            binders.add(binder);
        }
        msg.setBinders(binders);
    }

    private void parseSelectedIdentity(PreSharedKeyExtensionMessage msg) {
        msg.setSelectedIdentity(this.parseIntField(2));
        LOGGER.debug("SelectedIdentity:: {}", msg.getSelectedIdentity().getValue());
    }
}

