/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerNamePairParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNameIndicationExtensionParser
extends ExtensionParser<ServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ServerNamePair> pairList;

    public ServerNameIndicationExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(ServerNameIndicationExtensionMessage msg) {
        if (this.getBytesLeft() > 0) {
            this.parseServerNameListLength(msg);
            this.parseServerNameListBytes(msg);
            this.pairList = new LinkedList<ServerNamePair>();
            ByteArrayInputStream innerStream = new ByteArrayInputStream((byte[])msg.getServerNameListBytes().getValue());
            try {
                while (innerStream.available() > 0) {
                    ServerNamePairParser parser = new ServerNamePairParser(innerStream);
                    ServerNamePair pair = new ServerNamePair();
                    parser.parse(pair);
                    this.pairList.add(pair);
                }
                this.parseServerNameList(msg);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse ServerNamePairs");
            }
        } else {
            LOGGER.debug("Received empty SNI Extension");
        }
    }

    private void parseServerNameListLength(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameListLength(this.parseIntField(2));
        LOGGER.debug("ServerNameListLength: {}", msg.getServerNameListLength().getValue());
    }

    private void parseServerNameListBytes(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameListBytes(this.parseByteArrayField((Integer)msg.getServerNameListLength().getValue()));
        LOGGER.debug("ServerNameListBytes: {}", msg.getServerNameListBytes().getValue());
    }

    private void parseServerNameList(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameList(this.pairList);
    }
}

