/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNamePairParser
extends Parser<ServerNamePair> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerNamePairParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(ServerNamePair pair) {
        this.parseServerNameType(pair);
        this.parseServerNameLength(pair);
        this.parseServerName(pair);
        pair.setServerNameConfig((byte[])pair.getServerName().getValue());
        pair.setServerNameTypeConfig((Byte)pair.getServerNameType().getValue());
    }

    private void parseServerNameType(ServerNamePair pair) {
        pair.setServerNameType(this.parseByteField(1));
        LOGGER.debug("ServerNameType: {}", pair.getServerNameType().getValue());
    }

    private void parseServerNameLength(ServerNamePair pair) {
        pair.setServerNameLength(this.parseIntField(2));
        LOGGER.debug("ServerNameLength: {}", pair.getServerNameLength().getValue());
    }

    private void parseServerName(ServerNamePair pair) {
        pair.setServerName(this.parseByteArrayField((Integer)pair.getServerNameLength().getValue()));
        LOGGER.debug("ServerName: {}", pair.getServerName().getValue());
    }
}

