/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension.keyshare;

import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.DragonFlyKeyShareEntry;
import java.io.InputStream;
import java.math.BigInteger;

public class DragonFlyKeyShareEntryParser
extends Parser<DragonFlyKeyShareEntry> {
    private final NamedGroup group;

    public DragonFlyKeyShareEntryParser(InputStream stream, NamedGroup group) {
        super(stream);
        this.group = group;
    }

    @Override
    public void parse(DragonFlyKeyShareEntry keyShare) {
        if (!this.group.isEcGroup()) {
            throw new UnsupportedOperationException("Non-Curves are currently not supported");
        }
        EllipticCurve curve = ((NamedEllipticCurveParameters)this.group.getGroupParameters()).getGroup();
        int elementLength = curve.getModulus().bitLength();
        byte[] rawPublicKey = this.parseByteArrayField(elementLength * 2 / 8);
        int scalarLength = this.parseIntField(1);
        BigInteger scalar = this.parseBigIntField(scalarLength);
        keyShare.setRawPublicKey(rawPublicKey);
        keyShare.setScalar(scalar);
        keyShare.setScalarLength(scalarLength);
    }
}

