/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension.quic;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameterEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameters;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParametersExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.constants.QuicTransportParameterEntryTypes;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;

public class QuicTransportParametersExtensionParser
extends ExtensionParser<QuicTransportParametersExtensionMessage> {
    public QuicTransportParametersExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(QuicTransportParametersExtensionMessage msg) {
        while (this.getBytesLeft() > 0) {
            QuicTransportParameterEntry entry = new QuicTransportParameterEntry();
            QuicTransportParameterEntryTypes types = QuicTransportParameterEntryTypes.getParameterEntryType(this.parseByteField(1));
            if (types == QuicTransportParameterEntryTypes.GOOGLE || types == QuicTransportParameterEntryTypes.PROVISIONAL_PARAMETERS) {
                this.parseByteField(1);
            } else if (types == QuicTransportParameterEntryTypes.UNKNOWN) {
                this.parseTillEnd();
                break;
            }
            byte length = this.parseByteField(1);
            byte[] value = this.parseByteArrayField(length);
            entry.setEntryType(types);
            entry.setEntryLength(length);
            entry.setEntryValue(value);
            msg.getTransportParameterEntries().add(entry);
        }
        msg.setQuicTransportParameters(new QuicTransportParameters(msg.getTransportParameterEntries()));
    }
}

