/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.message.AckMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AckPreperator
extends ProtocolMessagePreparator<AckMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext tlsContext;

    public AckPreperator(Chooser chooser, AckMessage message, TlsContext tlsContext) {
        super(chooser, message);
        this.tlsContext = tlsContext;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        LOGGER.debug("Preparing AckMessage");
        this.prepareRecordNumbers();
        this.prepareRecordNumbersLength();
    }

    private void prepareRecordNumbersLength() {
        ((AckMessage)this.message).setRecordNumberLength(((AckMessage)this.message).getRecordNumbers().size() * 16);
        LOGGER.debug("RecordNumberLength: {}", ((AckMessage)this.message).getRecordNumberLength().getValue());
    }

    private void prepareRecordNumbers() {
        if (((AckMessage)this.message).getRecordNumbers() == null) {
            ((AckMessage)this.message).setRecordNumbers(new LinkedList<RecordNumber>());
        }
        if (this.tlsContext.getDtls13AcknowledgedRecords() != null) {
            ((AckMessage)this.message).getRecordNumbers().addAll(this.tlsContext.getDtls13AcknowledgedRecords());
            this.tlsContext.getDtls13AcknowledgedRecords().clear();
        }
        LOGGER.debug("RecordNumbers: ");
        for (RecordNumber recordNumber : ((AckMessage)this.message).getRecordNumbers()) {
            LOGGER.debug("\t - {}", (Object)recordNumber);
        }
    }
}

