/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.cert.CertificateEntryPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.cert.CertificatePairSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.context.X509Context;
import de.rub.nds.x509attacker.filesystem.CertificateBytes;
import de.rub.nds.x509attacker.x509.X509CertificateChainBuilder;
import de.rub.nds.x509attacker.x509.X509ChainCreationResult;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import de.rub.nds.x509attacker.x509.preparator.X509CertificatePreparator;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;

public class CertificateMessagePreparator
extends HandshakeMessagePreparator<CertificateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateMessage msg;

    public CertificateMessagePreparator(Chooser chooser, CertificateMessage msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing CertificateMessage");
        if (this.chooser.getSelectedProtocolVersion().is13()) {
            this.prepareRequestContext(this.msg);
            this.prepareRequestContextLength(this.msg);
        }
        this.prepareCertificateListBytes(this.msg);
    }

    private CertificateType selectTypeInternally() {
        if (this.chooser.getContext().getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            return this.chooser.getSelectedServerCertificateType();
        }
        return this.chooser.getSelectedClientCertificateType();
    }

    private void prepareCertificateListBytes(CertificateMessage msg) {
        switch (this.selectTypeInternally()) {
            case OPEN_PGP: {
                throw new UnsupportedOperationException("We do not support OpenPGP keys");
            }
            case RAW_PUBLIC_KEY: {
                LOGGER.debug("Adjusting context for RAW PUBLIC KEY certificate message");
                try {
                    SilentByteArrayOutputStream byteArrayOutputStream = new SilentByteArrayOutputStream();
                    ASN1OutputStream asn1OutputStream = ASN1OutputStream.create((OutputStream)byteArrayOutputStream);
                    Point ecPointToEncode = this.chooser.getContext().getTlsContext().getTalkingX509Context().getSubjectEcPublicKey();
                    asn1OutputStream.writeObject((ASN1Primitive)new DLSequence(new ASN1Encodable[]{new DLSequence(new ASN1Encodable[]{new ASN1ObjectIdentifier("1.2.840.10045.2.1"), new ASN1ObjectIdentifier("1.2.840.10045.3.1.7")}), new DERBitString(PointFormatter.formatToByteArray((GroupParameters)NamedEllipticCurveParameters.SECP256R1, (Point)ecPointToEncode, (PointFormat)PointFormat.UNCOMPRESSED))}));
                    asn1OutputStream.flush();
                    msg.setCertificatesListBytes(byteArrayOutputStream.toByteArray());
                    msg.setCertificatesListLength(((byte[])msg.getCertificatesListBytes().getValue()).length);
                }
                catch (Exception e) {
                    LOGGER.warn("Could write RAW PublicKey. Not writing anything", (Throwable)e);
                    msg.setCertificatesListBytes(new byte[0]);
                    msg.setCertificatesListLength(((byte[])msg.getCertificatesListBytes().getValue()).length);
                }
                break;
            }
            case X509: {
                List<CertificateEntry> entryList = msg.getCertificateEntryList();
                if (this.chooser.getConfig().getDefaultExplicitCertificateChain() == null) {
                    if (entryList == null) {
                        if (this.chooser.getConfig().getAutoAdjustCertificate().booleanValue()) {
                            X509PublicKeyType[] certificateKeyTypes = AlgorithmResolver.getSuitableLeafCertificateKeyType(this.chooser.getSelectedCipherSuite());
                            if (certificateKeyTypes.length > 0) {
                                this.autoSelectCertificateKeyType(certificateKeyTypes);
                            } else {
                                LOGGER.warn("Could not adjust public key in certificate to fit cipher suite");
                            }
                        }
                        LOGGER.debug("Building new certificate chain");
                        X509CertificateChainBuilder builder = new X509CertificateChainBuilder();
                        X509ChainCreationResult chainResult = builder.buildChain(this.chooser.getConfig().getCertificateChainConfig());
                        this.chooser.getContext().getTlsContext().setTalkingX509Context(chainResult.getContext());
                        entryList = new LinkedList<CertificateEntry>();
                        for (X509Certificate certificate : chainResult.getCertificateChain().getCertificateList()) {
                            entryList.add(new CertificateEntry(certificate));
                        }
                        msg.setCertificateEntryList(entryList);
                    } else {
                        this.preparePredefinedCerts(entryList);
                    }
                    this.prepareFromEntryList(msg);
                } else {
                    entryList = new LinkedList<CertificateEntry>();
                    for (CertificateBytes certificateBytes : this.chooser.getConfig().getDefaultExplicitCertificateChain()) {
                        CertificateEntry entry = new CertificateEntry(certificateBytes.getBytes());
                        entryList.add(entry);
                    }
                    msg.setCertificateEntryList(entryList);
                    this.prepareFromEntryList(msg);
                }
                LOGGER.debug("CertificatesListBytes: {}", msg.getCertificatesListBytes().getValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported CertificateType");
            }
        }
    }

    private void autoSelectCertificateKeyType(X509PublicKeyType[] certificateKeyTypes) {
        if (this.chooser.getConfig().getAutoAdjustSignatureAndHashAlgorithm().booleanValue()) {
            this.chooser.getConfig().getCertificateChainConfig().get(0).setPublicKeyType(certificateKeyTypes[0]);
        } else {
            for (X509PublicKeyType certKeyType : certificateKeyTypes) {
                if (!this.chooser.getConfig().getDefaultSelectedSignatureAndHashAlgorithm().suitableForSignatureKeyType(certKeyType)) continue;
                this.chooser.getConfig().getCertificateChainConfig().get(0).setPublicKeyType(certKeyType);
                return;
            }
            LOGGER.warn("Could not find certificate public key type matching both cipher suite and default SignatureAndHashAlgorithm. Using first key type.");
            this.chooser.getConfig().getCertificateChainConfig().get(0).setPublicKeyType(certificateKeyTypes[0]);
        }
    }

    private void preparePredefinedCerts(List<CertificateEntry> entryList) {
        X509CertificateConfig certConfig;
        X509Context x509Context = new X509Context();
        for (int i = this.chooser.getConfig().getCertificateChainConfig().size() - 1; i >= 0; --i) {
            if (i >= entryList.size()) {
                LOGGER.warn("Not enough certificates provided for certificate chain config. Ignoring trailing config.");
                continue;
            }
            certConfig = this.chooser.getConfig().getCertificateChainConfig().get(i);
            this.prepareCert(entryList, x509Context, certConfig, i);
        }
        int certsBeyondConfigs = entryList.size() - this.chooser.getConfig().getCertificateChainConfig().size();
        if (certsBeyondConfigs > 0) {
            LOGGER.warn("Found {} more certificates than provided certificate configs. Using first config to prepare remaining entries.", (Object)certsBeyondConfigs);
            certConfig = this.chooser.getConfig().getCertificateChainConfig().get(0);
            for (int i = entryList.size() - this.chooser.getConfig().getCertificateChainConfig().size() - 1; i >= 0; --i) {
                this.prepareCert(entryList, x509Context, certConfig, i);
            }
        }
        this.chooser.getContext().getTlsContext().setTalkingX509Context(x509Context);
    }

    private void prepareCert(List<CertificateEntry> entryList, X509Context x509Context, X509CertificateConfig certConfig, int i) {
        X509Certificate certificate = entryList.get(i).getX509certificate();
        X509Chooser chooser = new X509Chooser(certConfig, x509Context);
        X509CertificatePreparator preparator = new X509CertificatePreparator(chooser, certificate);
        preparator.prepare();
    }

    private void prepareFromEntryList(CertificateMessage msg) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (CertificateEntry pair : msg.getCertificateEntryList()) {
            CertificateEntryPreparator preparator = new CertificateEntryPreparator(this.chooser, pair);
            preparator.prepare();
            CertificatePairSerializer serializer = new CertificatePairSerializer(pair, this.chooser.getSelectedProtocolVersion());
            stream.write(serializer.serialize());
        }
        msg.setCertificatesListBytes(stream.toByteArray());
        msg.setCertificatesListLength(((byte[])msg.getCertificatesListBytes().getValue()).length);
    }

    private void prepareRequestContext(CertificateMessage msg) {
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            msg.setRequestContext(this.chooser.getCertificateRequestContext());
        } else {
            msg.setRequestContext(new byte[0]);
        }
        LOGGER.debug("RequestContext: {}", msg.getRequestContext().getValue());
    }

    private void prepareRequestContextLength(CertificateMessage msg) {
        msg.setRequestContextLength(((byte[])msg.getRequestContext().getValue()).length);
        LOGGER.debug("RequestContextLength: {}", msg.getRequestContextLength().getValue());
    }
}

