/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CoreClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HelloMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CoreClientHelloPreparator<T extends CoreClientHelloMessage>
extends HelloMessagePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public CoreClientHelloPreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing ClientHelloMessage");
        this.prepareProtocolVersion(this.msg);
        this.prepareRandom();
        this.prepareCompressions(this.msg);
        this.prepareCompressionLength(this.msg);
        this.prepareCipherSuites(this.msg);
        this.prepareCipherSuitesLength(this.msg);
        if (this.isDTLS()) {
            this.prepareCookie(this.msg);
            this.prepareCookieLength(this.msg);
        }
        this.prepareExtensions();
        this.prepareExtensionLength();
        this.prepareSessionID();
        this.prepareSessionIDLength();
    }

    @Override
    protected void prepareRandom() {
        if (this.mustRetainPreviousClientRandom()) {
            ((HelloMessage)this.msg).setRandom(this.chooser.getClientRandom());
        } else {
            super.prepareRandom();
        }
    }

    private boolean mustRetainPreviousClientRandom() {
        return (this.isDTLS() || this.isHelloRetryRequestFlow()) && this.hasClientRandom();
    }

    private void prepareSessionID() {
        SessionTicketTLSExtensionMessage extensionMessage;
        boolean isResumptionWithSessionTicket = false;
        if (((HandshakeMessage)this.msg).containsExtension(ExtensionType.SESSION_TICKET) && (extensionMessage = ((HandshakeMessage)((Object)this.msg)).getExtension(SessionTicketTLSExtensionMessage.class)) != null && (Integer)extensionMessage.getSessionTicket().getIdentityLength().getValue() > 0) {
            isResumptionWithSessionTicket = true;
        }
        if (isResumptionWithSessionTicket && this.chooser.getConfig().isOverrideSessionIdForTickets().booleanValue()) {
            ((HelloMessage)this.msg).setSessionId(this.chooser.getConfig().getDefaultClientTicketResumptionSessionId());
        } else if (this.chooser.getContext().getTlsContext().getServerSessionId() == null) {
            ((HelloMessage)this.msg).setSessionId(this.chooser.getClientSessionId());
        } else {
            ((HelloMessage)this.msg).setSessionId(this.chooser.getServerSessionId());
        }
        LOGGER.debug("SessionId: {}", ((HelloMessage)this.msg).getSessionId().getValue());
    }

    private boolean isDTLS() {
        return this.chooser.getSelectedProtocolVersion().isDTLS();
    }

    private boolean isHelloRetryRequestFlow() {
        if (this.chooser.getContext().getTlsContext().getSelectedProtocolVersion() == ProtocolVersion.TLS13) {
            return this.chooser.getContext().getTlsContext().getDigest().getRawBytes().length > 0 && this.chooser.getContext().getTlsContext().getDigest().getRawBytes()[0] == HandshakeMessageType.MESSAGE_HASH.getValue();
        }
        return false;
    }

    private byte[] convertCompressions(List<CompressionMethod> compressionList) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (CompressionMethod compression : compressionList) {
            stream.write(compression.getArrayValue());
        }
        return stream.toByteArray();
    }

    private byte[] convertCipherSuites(List<CipherSuite> suiteList) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (CipherSuite suite : suiteList) {
            stream.write(suite.getByteValue());
        }
        return stream.toByteArray();
    }

    private void prepareProtocolVersion(T msg) {
        if (this.chooser.getConfig().getHighestProtocolVersion().isTLS13()) {
            ((HelloMessage)msg).setProtocolVersion(ProtocolVersion.TLS12.getValue());
        } else if (this.chooser.getConfig().getHighestProtocolVersion().isDTLS13()) {
            ((HelloMessage)msg).setProtocolVersion(ProtocolVersion.DTLS12.getValue());
        } else {
            ((HelloMessage)msg).setProtocolVersion(this.chooser.getConfig().getHighestProtocolVersion().getValue());
        }
        LOGGER.debug("ProtocolVersion: {}", ((HelloMessage)msg).getProtocolVersion().getValue());
    }

    private void prepareCompressions(T msg) {
        if (this.chooser.getConfig().getHighestProtocolVersion().is13()) {
            ((CoreClientHelloMessage)msg).setCompressions(CompressionMethod.NULL.getArrayValue());
        } else {
            ((CoreClientHelloMessage)msg).setCompressions(this.convertCompressions(this.chooser.getConfig().getDefaultClientSupportedCompressionMethods()));
        }
        LOGGER.debug("Compressions: {}", ((CoreClientHelloMessage)msg).getCompressions().getValue());
    }

    private void prepareCompressionLength(T msg) {
        ((CoreClientHelloMessage)msg).setCompressionLength(((byte[])((CoreClientHelloMessage)msg).getCompressions().getValue()).length);
        LOGGER.debug("CompressionLength: {}", ((CoreClientHelloMessage)msg).getCompressionLength().getValue());
    }

    private void prepareCipherSuites(T msg) {
        ((CoreClientHelloMessage)msg).setCipherSuites(this.convertCipherSuites(this.chooser.getConfig().getDefaultClientSupportedCipherSuites()));
        LOGGER.debug("CipherSuites: {}", ((CoreClientHelloMessage)msg).getCipherSuites().getValue());
    }

    private void prepareCipherSuitesLength(T msg) {
        ((CoreClientHelloMessage)msg).setCipherSuiteLength(((byte[])((CoreClientHelloMessage)msg).getCipherSuites().getValue()).length);
        LOGGER.debug("CipherSuitesLength: {}", ((CoreClientHelloMessage)msg).getCipherSuiteLength().getValue());
    }

    private boolean hasClientRandom() {
        return this.chooser.getContext().getTlsContext().getClientRandom() != null;
    }

    private void prepareCookie(T msg) {
        if (this.chooser.getSelectedProtocolVersion().isDTLS13()) {
            ((CoreClientHelloMessage)msg).setCookie(new byte[0]);
        } else {
            ((CoreClientHelloMessage)msg).setCookie(this.chooser.getDtlsCookie());
        }
        LOGGER.debug("Cookie: {}", ((CoreClientHelloMessage)msg).getCookie().getValue());
    }

    private void prepareCookieLength(T msg) {
        ((CoreClientHelloMessage)msg).setCookieLength((byte)((byte[])((CoreClientHelloMessage)msg).getCookie().getValue()).length);
        LOGGER.debug("CookieLength: {}", ((CoreClientHelloMessage)msg).getCookieLength().getValue());
    }

    @Override
    public void afterPrepare() {
        this.afterPrepareExtensions();
    }
}

