/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeSenderContext;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeUtil;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EchConfig;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedClientHelloExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.alpn.AlpnEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.preparator.CoreClientHelloPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ServerNameIndicationExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientHelloSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.EncryptedClientHelloExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ServerNameIndicationExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedClientHelloPreparator
extends CoreClientHelloPreparator<EncryptedClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int PADDED_LENGTH = 32;
    private final EncryptedClientHelloMessage msg;
    private byte[] sessionId;
    private final EchConfig echConfig;
    private HpkeSenderContext hpkeSenderContext;
    private byte[] clientHelloInnerValue;

    public EncryptedClientHelloPreparator(Chooser chooser, EncryptedClientHelloMessage message) {
        super(chooser, message);
        this.msg = message;
        this.echConfig = chooser.getEchConfig();
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing EncryptedClientHelloMessage");
        this.prepareClientHelloInner();
        this.prepareEncodedClientHelloInner();
        this.prepareHpkeContext();
        this.prepareClientHelloOuterAAD();
        this.prepareEncryptClientHelloOuter();
        this.prepareExtensions();
        this.prepareExtensionLength();
    }

    private void prepareClientHelloInner() {
        LOGGER.debug("Preparing ClientHelloInner");
        ClientHelloMessage clientHelloInner = new ClientHelloMessage(this.chooser.getConfig());
        clientHelloInner.getPreparator(this.chooser.getContext()).prepare();
        byte[] clientHelloInnerBytes = new ClientHelloSerializer(clientHelloInner, this.chooser.getSelectedProtocolVersion()).serialize();
        clientHelloInner.setCompleteResultingMessage(clientHelloInnerBytes);
        clientHelloInner.getHandler(this.chooser.getContext()).adjustContext(clientHelloInner);
        this.msg.setClientHelloInner(clientHelloInner);
    }

    private void prepareEncodedClientHelloInner() {
        LOGGER.debug("Encoding ClientHelloInner");
        ClientHelloMessage clientHelloInner = this.msg.getClientHelloInner();
        this.sessionId = (byte[])clientHelloInner.getSessionId().getValue();
        clientHelloInner.setSessionIdLength(0);
        clientHelloInner.setSessionId(new byte[0]);
        this.clientHelloInnerValue = clientHelloInner.getSerializer(this.chooser.getContext()).serializeHandshakeMessageContent();
        int padding = 0;
        AlpnExtensionMessage alpnExtensionMessage = clientHelloInner.getExtension(AlpnExtensionMessage.class);
        int alpnPaddingLength = 0;
        if (alpnExtensionMessage != null) {
            alpnPaddingLength = (Integer)alpnExtensionMessage.getExtensionLength().getValue();
            alpnPaddingLength = Math.max(0, this.chooser.getConfig().getDefaultMaxEchAlpnPadding() - alpnPaddingLength);
            padding += alpnPaddingLength;
        }
        ServerNameIndicationExtensionMessage serverNameIndicationExtensionMessage = clientHelloInner.getExtension(ServerNameIndicationExtensionMessage.class);
        int sniPaddingLength = 0;
        if (serverNameIndicationExtensionMessage != null) {
            sniPaddingLength = (Integer)serverNameIndicationExtensionMessage.getExtensionLength().getValue();
            sniPaddingLength = Math.max(0, this.chooser.getEchConfig().getMaximumNameLength() - sniPaddingLength);
            padding += sniPaddingLength;
        }
        int message_size = this.clientHelloInnerValue.length + alpnPaddingLength + sniPaddingLength;
        byte[] paddingBytes = new byte[padding += 31 - (message_size - 1) % 32];
        this.msg.setEncodedClientHelloInnerPadding(paddingBytes);
        LOGGER.debug("Encoded ClientHello inner: {}", (Object)this.clientHelloInnerValue);
        LOGGER.debug("Padding length: {}", (Object)padding);
    }

    private void prepareHpkeContext() {
        LOGGER.debug("Preparing HPKEContext");
        LOGGER.debug("ClientPrivateKey: {}", (Object)this.chooser.getEchClientKeyShareEntry().getPrivateKey().toByteArray());
        LOGGER.debug("ClientPublicKey: {}", this.chooser.getEchClientKeyShareEntry().getPublicKey().getValue());
        HpkeUtil hpkeUtil = new HpkeUtil(this.echConfig.getHpkeAeadFunction(), this.echConfig.getHpkeKeyDerivationFunction(), this.echConfig.getKem());
        byte[] info = DataConverter.concatenate((byte[][])new byte[][]{"tls ech".getBytes(StandardCharsets.US_ASCII), {0}, this.chooser.getEchConfig().getEchConfigBytes()});
        LOGGER.debug("Info: {}", (Object)info);
        try {
            this.hpkeSenderContext = hpkeUtil.setupBaseSender(this.chooser.getEchConfig().getHpkePublicKey(), info, this.chooser.getEchClientKeyShareEntry());
        }
        catch (CryptoException e) {
            LOGGER.error("Could not create Hpke Context in EncryptedClientHello");
        }
        LOGGER.debug("Enc: {}", (Object)hpkeUtil.getPublicKeySender());
    }

    private void prepareClientHelloOuterAAD() {
        PreSharedKeyExtensionMessage preSharedKeyExtensionMessage;
        AlpnExtensionMessage alpnExtensionMessage;
        LOGGER.debug("Preparing ClientHelloOuterAAD");
        int clientHelloInnerLength = this.clientHelloInnerValue.length;
        int payloadLength = (clientHelloInnerLength += ((byte[])this.msg.getEncodedClientHelloInnerPadding().getValue()).length) + this.echConfig.getHpkeAeadFunction().getTagLength();
        EncryptedClientHelloExtensionMessage encryptedClientHelloExtensionMessage = this.msg.getEncryptedClientHelloExtensionMessage();
        encryptedClientHelloExtensionMessage.setPayload(new byte[payloadLength]);
        encryptedClientHelloExtensionMessage.setPayloadLength(payloadLength);
        super.prepareHandshakeMessageContents();
        this.msg.setSessionId(this.sessionId);
        ServerNameIndicationExtensionMessage serverNameIndicationExtensionMessage = this.msg.getExtension(ServerNameIndicationExtensionMessage.class);
        if (serverNameIndicationExtensionMessage != null) {
            byte[] serverName = this.chooser.getEchConfig().getPublicDomainName();
            ServerNamePair serverNamePair = serverNameIndicationExtensionMessage.getServerNameList().get(0);
            if (serverNamePair != null) {
                serverNamePair.setServerNameTypeConfig(this.chooser.getConfig().getSniType().getValue());
                serverNamePair.setServerNameConfig(serverName);
            }
            Iterator<PSKBinder> serializer = new ServerNameIndicationExtensionSerializer(serverNameIndicationExtensionMessage);
            ServerNameIndicationExtensionPreparator preparator = new ServerNameIndicationExtensionPreparator(this.chooser, serverNameIndicationExtensionMessage);
            preparator.prepare();
            serverNameIndicationExtensionMessage.setExtensionBytes(((Serializer)((Object)serializer)).serialize());
        }
        if ((alpnExtensionMessage = this.msg.getExtension(AlpnExtensionMessage.class)) != null) {
            LinkedList<AlpnEntry> alpnEntryList = new LinkedList<AlpnEntry>();
            alpnEntryList.add(new AlpnEntry(this.chooser.getConfig().getDefaultSelectedAlpnProtocol()));
            alpnExtensionMessage.setAlpnEntryList(alpnEntryList);
        }
        if ((preSharedKeyExtensionMessage = this.msg.getExtension(PreSharedKeyExtensionMessage.class)) != null) {
            for (PSKIdentity pskIdentity : preSharedKeyExtensionMessage.getIdentities()) {
                byte[] randomIdentity = new byte[((byte[])pskIdentity.getIdentity().getValue()).length];
                this.chooser.getContext().getTlsContext().getRandom().nextBytes(randomIdentity);
                ModifiableVariableFactory.safelySetValue((ModifiableByteArray)pskIdentity.getIdentity(), (byte[])randomIdentity);
                byte[] randomObfuscatedTicketAge = new byte[4];
                this.chooser.getContext().getTlsContext().getRandom().nextBytes(randomObfuscatedTicketAge);
                ModifiableVariableFactory.safelySetValue((ModifiableByteArray)pskIdentity.getObfuscatedTicketAge(), (byte[])randomObfuscatedTicketAge);
            }
            for (PSKBinder pskBinder : preSharedKeyExtensionMessage.getBinders()) {
                byte[] randomBinder = new byte[((byte[])pskBinder.getBinderEntry().getValue()).length];
                this.chooser.getContext().getTlsContext().getRandom().nextBytes(randomBinder);
                ModifiableVariableFactory.safelySetValue((ModifiableByteArray)pskBinder.getBinderEntry(), (byte[])randomBinder);
            }
        }
        EncryptedClientHelloPreparator preparator = new EncryptedClientHelloPreparator(this.chooser, (EncryptedClientHelloMessage)this.message);
        preparator.prepareExtensions();
        preparator.prepareExtensionLength();
    }

    private void prepareEncryptClientHelloOuter() {
        byte[] aad = this.msg.getSerializer(this.chooser.getContext()).serializeHandshakeMessageContent();
        LOGGER.debug("AAD: {}", (Object)aad);
        byte[] plaintext = DataConverter.concatenate((byte[][])new byte[][]{this.clientHelloInnerValue, (byte[])this.msg.getEncodedClientHelloInnerPadding().getValue()});
        LOGGER.debug("Plaintext: {}", (Object)plaintext);
        try {
            byte[] payload = this.hpkeSenderContext.seal(aad, plaintext);
            LOGGER.debug("Payload: {}", (Object)payload);
            EncryptedClientHelloExtensionMessage outerExtensionMessage = this.msg.getEncryptedClientHelloExtensionMessage();
            outerExtensionMessage.setPayload(payload);
            EncryptedClientHelloExtensionSerializer serializer = new EncryptedClientHelloExtensionSerializer(outerExtensionMessage);
            byte[] newContent = serializer.serialize();
            outerExtensionMessage.setExtensionBytes(newContent);
        }
        catch (CryptoException e) {
            LOGGER.error("Could not encrypt the inner ClientHello");
        }
    }
}

