/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.tlsattacker.core.constants.HeartbeatMessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatMessagePreparator
extends ProtocolMessagePreparator<HeartbeatMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HeartbeatMessage msg;

    public HeartbeatMessagePreparator(Chooser chooser, HeartbeatMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    private byte[] generatePayload() {
        int payloadLength = this.chooser.getConfig().getHeartbeatPayloadLength();
        if (payloadLength < 0) {
            LOGGER.warn("HeartBeat payload length is smaller than 0. Setting it to 0 instead");
            payloadLength = 0;
        } else if (payloadLength > 65536) {
            LOGGER.warn("HeartBeat payload length is bigger than the max value. Setting it to max value.");
            payloadLength = 65536;
        }
        byte[] payload = new byte[payloadLength];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(payload);
        return payload;
    }

    private byte[] generatePadding() {
        int paddingLength = this.chooser.getConfig().getHeartbeatPaddingLength();
        if (paddingLength < 0) {
            LOGGER.warn("HeartBeat padding length is smaller than 0. Setting it to 0 instead");
            paddingLength = 0;
        } else if (paddingLength > 65536) {
            LOGGER.warn("HeartBeat padding length is bigger than the max value. Setting it to max value.");
            paddingLength = 65536;
        }
        byte[] padding = new byte[paddingLength];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(padding);
        return padding;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        LOGGER.debug("Preparing HeartbeatMessage");
        this.prepareHeartbeatMessageType(this.msg);
        this.preparePayload(this.msg);
        this.preparePayloadLength(this.msg);
        this.preparePadding(this.msg);
    }

    private void prepareHeartbeatMessageType(HeartbeatMessage msg) {
        msg.setHeartbeatMessageType(HeartbeatMessageType.HEARTBEAT_REQUEST.getValue());
        LOGGER.debug("HeartbeatMessageType: {}", msg.getHeartbeatMessageType().getValue());
    }

    private void preparePayload(HeartbeatMessage msg) {
        msg.setPayload(this.generatePayload());
        LOGGER.debug("Payload: {}", msg.getPayload().getValue());
    }

    private void preparePayloadLength(HeartbeatMessage msg) {
        msg.setPayloadLength(((byte[])msg.getPayload().getValue()).length);
        LOGGER.debug("PayloadLength: {}", msg.getPayloadLength().getValue());
    }

    private void preparePadding(HeartbeatMessage msg) {
        msg.setPadding(this.generatePadding());
        LOGGER.debug("Padding: {}", msg.getPadding().getValue());
    }
}

