/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.util.TimeHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HelloMessagePreparator<T extends HelloMessage>
extends HandshakeMessagePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public HelloMessagePreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
    }

    protected void prepareRandom() {
        byte[] random;
        if (this.msg instanceof ServerHelloMessage && ((ServerHelloMessage)this.msg).isHelloRetryRequest().booleanValue()) {
            random = ServerHelloMessage.getHelloRetryRequestRandom();
        } else if (this.chooser.getConfig().isUseFreshRandom().booleanValue()) {
            if (this.chooser.getHighestProtocolVersion().is13()) {
                random = new byte[32];
                this.chooser.getContext().getTlsContext().getRandom().nextBytes(random);
                this.chooser.getContext().getTlsContext().setServerRandom(random);
            } else {
                random = new byte[28];
                this.chooser.getContext().getTlsContext().getRandom().nextBytes(random);
                ((HelloMessage)this.msg).setUnixTime(DataConverter.longToUint32Bytes((long)TimeHelper.getTime()));
                random = DataConverter.concatenate((byte[][])new byte[][]{(byte[])((HelloMessage)this.msg).getUnixTime().getValue(), random});
                this.chooser.getContext().getTlsContext().setServerRandom(random);
            }
        } else {
            random = this.chooser.getTalkingConnectionEnd() == ConnectionEndType.CLIENT ? this.chooser.getClientRandom() : this.chooser.getServerRandom();
        }
        ((HelloMessage)this.msg).setRandom(random);
        LOGGER.debug("Random: {}", ((HelloMessage)this.msg).getRandom().getValue());
    }

    protected void prepareSessionIDLength() {
        ((HelloMessage)this.msg).setSessionIdLength(((byte[])((HelloMessage)this.msg).getSessionId().getValue()).length);
        LOGGER.debug("SessionIdLength: {}", ((HelloMessage)this.msg).getSessionIdLength().getValue());
    }
}

