/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.tlsattacker.core.protocol.message.NewConnectionIdMessage;
import de.rub.nds.tlsattacker.core.protocol.message.connectionid.ConnectionId;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewConnectionIdPreparator
extends HandshakeMessagePreparator<NewConnectionIdMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewConnectionIdPreparator(Chooser chooser, NewConnectionIdMessage message) {
        super(chooser, message);
    }

    @Override
    protected void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing NewConnectionIdMessage");
        this.prepareUsage();
        this.prepareConnectionIds();
    }

    private void prepareUsage() {
        ((NewConnectionIdMessage)this.message).setUsage(this.chooser.getConfig().getDefaultUsageOfSentConnectionIds());
        LOGGER.debug("Usage: {}", (Object)((NewConnectionIdMessage)this.message).getUsage());
    }

    private void prepareConnectionIds() {
        ((NewConnectionIdMessage)this.message).setConnectionIds(new LinkedList<ConnectionId>());
        int length = 0;
        for (int i = 0; i < this.chooser.getNumberOfRequestedConnectionIds(); ++i) {
            ConnectionId cid = new ConnectionId(this.chooser.getConfig().getDefaultConnectionId());
            ((NewConnectionIdMessage)this.message).getConnectionIds().add(cid);
            length += (Integer)cid.getLength().getValue() + 1;
        }
        ((NewConnectionIdMessage)this.message).setConnectionIdsLength(length);
        LOGGER.debug("Number of Connection IDs: {}", (Object)this.chooser.getNumberOfRequestedConnectionIds());
    }
}

