/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.EllipticCurveSECP256R1;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PWDComputations;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PWDClientKeyExchangePreparator
extends ClientKeyExchangePreparator<PWDClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PWDClientKeyExchangeMessage msg;

    public PWDClientKeyExchangePreparator(Chooser chooser, PWDClientKeyExchangeMessage msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        EllipticCurve curve;
        LOGGER.debug("Preparing PWDClientKeyExchangeMessage");
        this.msg.prepareComputations();
        CyclicGroup group = this.chooser.getSelectedNamedGroup().getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        try {
            this.preparePasswordElement(this.msg);
        }
        catch (CryptoException e) {
            throw new PreparationException("Failed to generate password element", (Throwable)e);
        }
        this.prepareScalarElement(this.msg);
        byte[] premasterSecret = this.generatePremasterSecret(this.msg.getComputations().getPasswordElement(), this.msg.getComputations().getPrivateKeyScalar(), curve);
        this.preparePremasterSecret(this.msg, premasterSecret);
        this.prepareClientServerRandom(this.msg);
    }

    @Override
    public void prepareAfterParse() {
        EllipticCurve curve;
        this.msg.prepareComputations();
        CyclicGroup group = this.chooser.getSelectedNamedGroup().getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        byte[] premasterSecret = this.generatePremasterSecret(this.chooser.getContext().getTlsContext().getPwdPasswordElement(), this.chooser.getContext().getTlsContext().getServerPWDPrivate(), curve);
        this.preparePremasterSecret(this.msg, premasterSecret);
        this.prepareClientServerRandom(this.msg);
    }

    protected void preparePasswordElement(PWDClientKeyExchangeMessage msg) throws CryptoException {
        EllipticCurve curve;
        CyclicGroup group = this.chooser.getSelectedNamedGroup().getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        Point passwordElement = PWDComputations.computePasswordElement(this.chooser, curve);
        msg.getComputations().setPasswordElement(passwordElement);
        LOGGER.debug("PasswordElement.x: {}", (Object)DataConverter.bigIntegerToByteArray((BigInteger)passwordElement.getFieldX().getData()));
    }

    protected MacAlgorithm getMacAlgorithm(CipherSuite suite) {
        if (suite.isSHA256()) {
            return MacAlgorithm.HMAC_SHA256;
        }
        if (suite.isSHA384()) {
            return MacAlgorithm.HMAC_SHA384;
        }
        if (suite.name().endsWith("SHA")) {
            return MacAlgorithm.HMAC_SHA1;
        }
        throw new PreparationException("Unsupported Mac Algorithm for suite " + suite.toString());
    }

    protected List<ECPointFormat> getPointFormatList() {
        List<ECPointFormat> sharedPointFormats = new ArrayList<ECPointFormat>(this.chooser.getClientSupportedPointFormats());
        if (sharedPointFormats.isEmpty()) {
            LOGGER.warn("Don't know which point format to use for PWD. Check if pointFormats is set in config.");
            sharedPointFormats = this.chooser.getConfig().getDefaultClientSupportedPointFormats();
        }
        ArrayList<ECPointFormat> unsupportedFormats = new ArrayList<ECPointFormat>();
        if (!this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            List<ECPointFormat> clientPointFormats = this.chooser.getClientSupportedPointFormats();
            for (ECPointFormat f : sharedPointFormats) {
                if (clientPointFormats.contains((Object)f)) continue;
                unsupportedFormats.add(f);
            }
        }
        sharedPointFormats.removeAll(unsupportedFormats);
        if (sharedPointFormats.isEmpty()) {
            sharedPointFormats = new ArrayList<ECPointFormat>(this.chooser.getConfig().getDefaultClientSupportedPointFormats());
        }
        return sharedPointFormats;
    }

    protected void prepareScalarElement(PWDClientKeyExchangeMessage msg) {
        EllipticCurve curve;
        CyclicGroup group = this.chooser.getSelectedNamedGroup().getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        PWDComputations.PWDKeyMaterial keyMaterial = PWDComputations.generateKeyMaterial(curve, msg.getComputations().getPasswordElement(), this.chooser);
        msg.getComputations().setPrivateKeyScalar(keyMaterial.privateKeyScalar);
        LOGGER.debug("Private: {}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)keyMaterial.privateKeyScalar)});
        this.prepareScalar(msg, keyMaterial.scalar);
        this.prepareScalarLength(msg);
        this.prepareElement(msg, keyMaterial.element);
        this.prepareElementLength(msg);
    }

    protected void prepareScalar(PWDClientKeyExchangeMessage msg, BigInteger scalar) {
        msg.setScalar(DataConverter.bigIntegerToByteArray((BigInteger)scalar));
        LOGGER.debug("Scalar: {}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)scalar)});
    }

    protected void prepareScalarLength(PWDClientKeyExchangeMessage msg) {
        msg.setScalarLength(((byte[])msg.getScalar().getValue()).length);
        LOGGER.debug("ScalarLength: {}", (Object)msg.getScalarLength());
    }

    protected void prepareElement(PWDClientKeyExchangeMessage msg, Point element) {
        byte[] serializedElement = PointFormatter.formatToByteArray(this.chooser.getConfig().getDefaultSelectedNamedGroup().getGroupParameters(), (Point)element, (PointFormat)this.chooser.getConfig().getDefaultSelectedPointFormat().getFormat());
        msg.setElement(serializedElement);
        LOGGER.debug("Element: {}", (Object)serializedElement);
    }

    protected void prepareElementLength(PWDClientKeyExchangeMessage msg) {
        msg.setElementLength(((byte[])msg.getElement().getValue()).length);
        LOGGER.debug("ElementLength: {}", (Object)msg.getElementLength());
    }

    private byte[] generatePremasterSecret(Point passwordElement, BigInteger privateKeyScalar, EllipticCurve curve) {
        BigInteger peerScalar;
        Point peerElement;
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            peerElement = this.chooser.getContext().getTlsContext().getServerPWDElement();
            peerScalar = this.chooser.getContext().getTlsContext().getServerPWDScalar();
        } else {
            peerElement = PointFormatter.formatFromByteArray(this.chooser.getSelectedNamedGroup().getGroupParameters(), (byte[])((byte[])this.msg.getElement().getValue()));
            peerScalar = new BigInteger(1, (byte[])this.msg.getScalar().getValue());
        }
        if (peerElement == null || peerScalar == null) {
            LOGGER.warn("Missing peer element or scalar, returning empty premaster secret");
            return new byte[0];
        }
        Point sharedSecret = curve.mult(privateKeyScalar, curve.add(curve.mult(peerScalar, passwordElement), peerElement));
        return DataConverter.bigIntegerToByteArray((BigInteger)sharedSecret.getFieldX().getData());
    }

    private void preparePremasterSecret(PWDClientKeyExchangeMessage msg, byte[] premasterSecret) {
        msg.getComputations().setPremasterSecret(premasterSecret);
        LOGGER.debug("PremasterSecret: {}", msg.getComputations().getPremasterSecret().getValue());
    }

    private void prepareClientServerRandom(PWDClientKeyExchangeMessage msg) {
        byte[] clientRandom = DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        msg.getComputations().setClientServerRandom(clientRandom);
        LOGGER.debug("ClientServerRandom: {}", msg.getComputations().getClientServerRandom().getValue());
    }
}

