/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.DHClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDhClientKeyExchangePreparator
extends DHClientKeyExchangePreparator<PskDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskDhClientKeyExchangeMessage msg;
    private SilentByteArrayOutputStream outputStream;

    public PskDhClientKeyExchangePreparator(Chooser chooser, PskDhClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        super.prepareHandshakeMessageContents();
    }

    @Override
    protected byte[] calculatePremasterSecret(BigInteger modulus, BigInteger privateKey, BigInteger publicKey) {
        byte[] otherSecret = super.calculatePremasterSecret(modulus, privateKey, publicKey);
        this.outputStream = new SilentByteArrayOutputStream();
        this.outputStream.write(DataConverter.intToBytes((int)otherSecret.length, (int)2));
        LOGGER.debug("OtherSecret Length: {}", (Object)otherSecret.length);
        this.outputStream.write(otherSecret);
        LOGGER.debug("OtherSecret: {}", (Object)otherSecret);
        this.outputStream.write(DataConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
        this.outputStream.write(this.chooser.getConfig().getDefaultPSKKey());
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        LOGGER.debug("PSK PremasterSecret: {}", (Object)tempPremasterSecret);
        return tempPremasterSecret;
    }

    @Override
    public void prepareAfterParse() {
        this.msg.prepareComputations();
        this.prepareClientServerRandom(this.msg);
        this.setComputationGenerator(this.msg);
        this.setComputationModulus(this.msg);
        this.setComputationPrivateKey(this.msg);
        this.setComputationPublicKey(this.msg);
        this.premasterSecret = this.calculatePremasterSecret((BigInteger)this.msg.getComputations().getModulus().getValue(), (BigInteger)this.msg.getComputations().getPrivateKey().getValue(), (BigInteger)this.msg.getComputations().getPublicKey().getValue());
        this.preparePremasterSecret(this.msg);
    }
}

