/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ECDHClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskEcDhClientKeyExchangePreparator
extends ECDHClientKeyExchangePreparator<PskEcDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private SilentByteArrayOutputStream outputStream;
    private final PskEcDhClientKeyExchangeMessage msg;

    public PskEcDhClientKeyExchangePreparator(Chooser chooser, PskEcDhClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        super.prepareHandshakeMessageContents();
    }

    @Override
    protected byte[] computePremasterSecret(EllipticCurve curve, Point publicKey, BigInteger privateKey) {
        byte[] premasterSecret = super.computePremasterSecret(curve, publicKey, privateKey);
        this.outputStream = new SilentByteArrayOutputStream();
        this.outputStream.write(DataConverter.intToBytes((int)premasterSecret.length, (int)2));
        LOGGER.debug("PremasterSecret: dhValue Length: {}", (Object)premasterSecret.length);
        this.outputStream.write(premasterSecret);
        LOGGER.debug("PremasterSecret: dhValue {}", (Object)premasterSecret);
        this.outputStream.write(DataConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
        this.outputStream.write(this.chooser.getConfig().getDefaultPSKKey());
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        LOGGER.debug("PSK PremasterSecret: {}", (Object)tempPremasterSecret);
        return tempPremasterSecret;
    }
}

