/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskServerKeyExchangePreparator
extends ServerKeyExchangePreparator<PskServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskServerKeyExchangeMessage msg;

    public PskServerKeyExchangePreparator(Chooser chooser, PskServerKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.prepareKeyExchangeComputations();
        this.msg.setIdentityHint(this.chooser.getPSKIdentityHint());
        this.msg.setIdentityHintLength(((byte[])this.msg.getIdentityHint().getValue()).length);
        this.msg.prepareKeyExchangeComputations();
        this.prepareClientServerRandom(this.msg);
    }

    private void prepareClientServerRandom(PskServerKeyExchangeMessage msg) {
        msg.getKeyExchangeComputations().setClientServerRandom(this.chooser.getClientRandom());
        LOGGER.debug("ClientServerRandom: {}", msg.getKeyExchangeComputations().getClientServerRandom().getValue());
    }
}

