/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2MessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientMasterKeyPreparator
extends SSL2MessagePreparator<SSL2ClientMasterKeyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SSL2ClientMasterKeyMessage message;
    private byte[] padding;
    private byte[] premasterSecret;
    private byte[] encryptedPremasterSecret;

    public SSL2ClientMasterKeyPreparator(Chooser chooser, SSL2ClientMasterKeyMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        LOGGER.debug("Prepare SSL2ClientMasterKey");
        this.prepareMessagePaddingLength(this.message);
        this.prepareType(this.message);
        this.prepareCipherKind(this.message);
        this.prepareClearKey(this.message);
        this.prepareClearKeyLength(this.message);
        this.prepareKeyArg(this.message);
        this.prepareKeyArgLength(this.message);
        LOGGER.debug("RSA Modulus: {}", (Object)this.chooser.getServerX509Chooser().getSubjectRsaModulus());
        this.prepareRSACiphertext(this.message);
        int length = 1;
        length += ((byte[])this.message.getCipherKind().getValue()).length;
        length += ((byte[])this.message.getClearKeyData().getValue()).length + 2;
        length += ((byte[])this.message.getEncryptedKeyData().getValue()).length + 2;
        this.prepareMessageLength(this.message, length += ((byte[])this.message.getKeyArgData().getValue()).length + 2);
    }

    private void prepareMessagePaddingLength(SSL2ClientMasterKeyMessage message) {
        message.setPaddingLength(0);
        LOGGER.debug("MessagePaddingLength: {}", message.getPaddingLength().getValue());
    }

    private void prepareType(SSL2ClientMasterKeyMessage message) {
        message.setType(message.getSsl2MessageType().getType());
        LOGGER.debug("Type: {}", message.getType().getValue());
    }

    private void prepareCipherKind(SSL2ClientMasterKeyMessage message) {
        message.setCipherKind(this.chooser.getSSL2CipherSuite().getByteValue());
        LOGGER.debug("CipherKind: {}", message.getCipherKind().getValue());
    }

    private void prepareClearKey(SSL2ClientMasterKeyMessage message) {
        message.setClearKeyData(new byte[this.chooser.getSSL2CipherSuite().getClearKeyByteNumber()]);
        LOGGER.debug("ClearKey: {}", message.getClearKeyData().getValue());
    }

    private void prepareClearKeyLength(SSL2ClientMasterKeyMessage message) {
        message.setClearKeyLength(((byte[])message.getClearKeyData().getValue()).length);
        LOGGER.debug("ClearKeyLength: {}", message.getClearKeyLength().getValue());
    }

    private void prepareKeyArg(SSL2ClientMasterKeyMessage message) {
        byte[] keyArgData = new byte[this.chooser.getSSL2CipherSuite().getBlockSize()];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(keyArgData);
        message.setKeyArgData(keyArgData);
        LOGGER.debug("KeyArg: {}", (Object)keyArgData);
    }

    private void prepareKeyArgLength(SSL2ClientMasterKeyMessage message) {
        message.setKeyArgLength(((byte[])message.getKeyArgData().getValue()).length);
        LOGGER.debug("KeyArgLength: {}", message.getKeyArgLength().getValue());
    }

    private void prepareMessageLength(SSL2ClientMasterKeyMessage message, int length) {
        message.setMessageLength(length);
        LOGGER.debug("MessageLength: {}", message.getMessageLength().getValue());
    }

    protected void preparePadding(SSL2ClientMasterKeyMessage msg) {
        msg.getComputations().setPadding(this.padding);
        LOGGER.debug("Padding: {}", msg.getComputations().getPadding().getValue());
    }

    private byte[] generatePremasterSecret() {
        byte[] tempPremasterSecret = new byte[this.chooser.getSSL2CipherSuite().getSecretKeyByteNumber()];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(tempPremasterSecret);
        return tempPremasterSecret;
    }

    protected void preparePremasterSecret(SSL2ClientMasterKeyMessage msg) {
        msg.getComputations().setPremasterSecret(this.premasterSecret);
        LOGGER.debug("PremasterSecret: {}", msg.getComputations().getPremasterSecret().getValue());
    }

    protected void preparePlainPaddedPremasterSecret(SSL2ClientMasterKeyMessage msg) {
        msg.getComputations().setPlainPaddedPremasterSecret(DataConverter.concatenate((byte[][])new byte[][]{{0, 2}, this.padding, {0}, (byte[])msg.getComputations().getPremasterSecret().getValue()}));
        LOGGER.debug("PlainPaddedPremasterSecret: {}", msg.getComputations().getPlainPaddedPremasterSecret().getValue());
    }

    protected void prepareEncryptedKeyData(SSL2ClientMasterKeyMessage msg) {
        msg.setEncryptedKeyData(this.encryptedPremasterSecret);
        LOGGER.debug("SerializedPublicKey: {}", msg.getEncryptedKeyData().getValue());
    }

    protected void prepareEncryptedKeyDataLength(SSL2ClientMasterKeyMessage msg) {
        msg.setEncryptedKeyLength(((byte[])msg.getEncryptedKeyData().getValue()).length);
        LOGGER.debug("SerializedPublicKeyLength: {}", msg.getEncryptedKeyLength().getValue());
    }

    private void prepareRSACiphertext(SSL2ClientMasterKeyMessage message) {
        message.prepareComputations();
        this.premasterSecret = this.generatePremasterSecret();
        this.preparePremasterSecret(message);
        int keyByteLength = this.chooser.getServerX509Chooser().getSubjectRsaModulus().bitLength() / 8;
        int unpaddedLength = ((byte[])message.getComputations().getPremasterSecret().getValue()).length;
        int randomByteLength = keyByteLength - unpaddedLength - 3;
        this.padding = randomByteLength >= 0 ? new byte[randomByteLength] : new byte[0];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(this.padding);
        DataConverter.makeArrayNonZero((byte[])this.padding);
        this.preparePadding(message);
        this.preparePlainPaddedPremasterSecret(message);
        byte[] paddedPremasterSecret = (byte[])message.getComputations().getPlainPaddedPremasterSecret().getValue();
        BigInteger biPaddedPremasterSecret = new BigInteger(1, paddedPremasterSecret);
        BigInteger biEncrypted = biPaddedPremasterSecret.modPow(this.chooser.getServerX509Chooser().getSubjectRsaPublicExponent(), this.chooser.getServerX509Chooser().getSubjectRsaModulus());
        this.encryptedPremasterSecret = DataConverter.bigIntegerToByteArray((BigInteger)biEncrypted, (int)(this.chooser.getServerX509Chooser().getSubjectRsaModulus().bitLength() / 8), (boolean)true);
        this.prepareEncryptedKeyData(message);
        this.prepareEncryptedKeyDataLength(message);
    }
}

