/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2MessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ServerHelloPreparator
extends SSL2MessagePreparator<SSL2ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ServerHelloPreparator(Chooser chooser, SSL2ServerHelloMessage message) {
        super(chooser, message);
    }

    @Override
    protected void prepareProtocolMessageContents() {
        LOGGER.debug("Prepare SSL2ServerHello");
        this.preparePaddingLength((SSL2ServerHelloMessage)this.message);
        this.prepareType((SSL2ServerHelloMessage)this.message);
        this.prepareProtocolVersion((SSL2ServerHelloMessage)this.message);
        this.prepareSessionIdHit((SSL2ServerHelloMessage)this.message);
        this.prepareSessionId((SSL2ServerHelloMessage)this.message);
        this.prepareSessionIdLength((SSL2ServerHelloMessage)this.message);
        this.prepareCertificate((SSL2ServerHelloMessage)this.message);
        this.prepareCertificateLength((SSL2ServerHelloMessage)this.message);
        this.prepareCertificateType((SSL2ServerHelloMessage)this.message);
        this.prepareCipherSuites((SSL2ServerHelloMessage)this.message);
        this.prepareCipherSuitesLength((SSL2ServerHelloMessage)this.message);
        this.prepareMessageLength((SSL2ServerHelloMessage)this.message);
    }

    private void prepareMessageLength(SSL2ServerHelloMessage message) {
        int length = 9;
        length += ((byte[])message.getCipherSuites().getValue()).length;
        length += ((byte[])message.getSessionId().getValue()).length;
        length += ((byte[])message.getProtocolVersion().getValue()).length;
        message.setMessageLength(length += ((Integer)message.getCertificateLength().getValue()).intValue());
        LOGGER.debug("MessageLength: {}", message.getMessageLength().getValue());
    }

    private void prepareCertificate(SSL2ServerHelloMessage message) {
        CertificateMessage certificateMessage = new CertificateMessage();
        certificateMessage.getPreparator(this.chooser.getContext()).prepare();
        message.setCertificate(certificateMessage.getCertificatesListBytes());
        LOGGER.debug("Certificate: {}", (Object)message.getCertificate());
    }

    private void prepareSessionIdLength(SSL2ServerHelloMessage message) {
        message.setSessionIDLength(0);
        LOGGER.debug("SessionIDLength: {}", (Object)message.getSessionIdLength());
    }

    private void prepareSessionId(SSL2ServerHelloMessage message) {
        message.setSessionID(new byte[0]);
        LOGGER.debug("SessionID: {}", (Object)message.getSessionId());
    }

    private void prepareCipherSuitesLength(SSL2ServerHelloMessage message) {
        message.setCipherSuitesLength(((byte[])message.getCipherSuites().getValue()).length);
        LOGGER.debug("CipherSuiteLength: {}", (Object)message.getCertificateLength());
    }

    private void prepareCertificateLength(SSL2ServerHelloMessage message) {
        message.setCertificateLength(((byte[])message.getCertificate().getValue()).length);
        LOGGER.debug("CertificateType: {}", (Object)message.getCertificateLength());
    }

    private void prepareCertificateType(SSL2ServerHelloMessage message) {
        message.setCertificateType(this.chooser.getSelectedServerCertificateType().getValue());
        LOGGER.debug("CertificateType: {}", message.getCertificateType().getValue());
    }

    private void prepareSessionIdHit(SSL2ServerHelloMessage message) {
        message.setSessionIdHit((byte)0);
        LOGGER.debug("SessionIdHit: {}", (Object)message.getSessionIdHit());
    }

    private void preparePaddingLength(SSL2ServerHelloMessage message) {
        message.setPaddingLength(0);
        LOGGER.debug("PaddingLength: {}", message.getPaddingLength().getValue());
    }

    private void prepareType(SSL2ServerHelloMessage message) {
        message.setType(message.getSsl2MessageType().getType());
    }

    private void prepareProtocolVersion(SSL2ServerHelloMessage message) {
        message.setProtocolVersion(ProtocolVersion.SSL2.getValue());
    }

    private void prepareCipherSuites(SSL2ServerHelloMessage message) {
        SilentByteArrayOutputStream cipherStream = new SilentByteArrayOutputStream();
        for (SSL2CipherSuite suite : this.chooser.getConfig().getDefaultServerSupportedSSL2CipherSuites()) {
            if (suite == SSL2CipherSuite.SSL_UNKNOWN_CIPHER) continue;
            cipherStream.write(suite.getByteValue());
        }
        message.setCipherSuites(cipherStream.toByteArray());
        LOGGER.debug("CipherSuites: {}", message.getCipherSuites().getValue());
    }
}

