/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.MessageDigestCollector;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeUtil;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HelloMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHelloPreparator
extends HelloMessagePreparator<ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String label = "ech accept confirmation";
    private final ServerHelloMessage msg;

    public ServerHelloPreparator(Chooser chooser, ServerHelloMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing ServerHelloMessage");
        this.prepareProtocolVersion();
        this.prepareRandom();
        this.prepareSessionID();
        this.prepareSessionIDLength();
        this.prepareCipherSuite();
        this.prepareCompressionMethod();
        if (this.chooser.getConfig().isRespectClientProposedExtensions().booleanValue() && this.msg.getExtensions() == null) {
            this.selectExtensions();
        }
        if (!this.chooser.getConfig().getHighestProtocolVersion().isSSL() || this.chooser.getConfig().getHighestProtocolVersion().isSSL() && this.chooser.getConfig().isAddExtensionsInSSL().booleanValue()) {
            this.prepareExtensions();
            this.prepareExtensionLength();
        }
        if (this.chooser.getContext().getTlsContext().isSupportsECH()) {
            this.prepareEchRandom();
        }
    }

    private void selectExtensions() {
        CipherSuite selectedCipherSuite;
        LinkedList<ExtensionType> permittedUnproposedExtensionTypes = new LinkedList<ExtensionType>();
        HashSet<ExtensionType> forbiddenExtensionTypes = new HashSet<ExtensionType>();
        if (this.chooser.getClientSupportedCipherSuites().contains((Object)CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV)) {
            permittedUnproposedExtensionTypes.add(ExtensionType.RENEGOTIATION_INFO);
        }
        if ((selectedCipherSuite = CipherSuite.getCipherSuite((byte[])this.msg.getSelectedCipherSuite().getValue())) != null && selectedCipherSuite.getKeyExchangeAlgorithm() != null && selectedCipherSuite.getKeyExchangeAlgorithm().isEC()) {
            forbiddenExtensionTypes.add(ExtensionType.EC_POINT_FORMATS);
        }
        if (selectedCipherSuite != null && selectedCipherSuite.isTls13()) {
            forbiddenExtensionTypes.addAll(ExtensionType.getNonTls13Extensions());
        } else {
            forbiddenExtensionTypes.addAll(ExtensionType.getTls13OnlyExtensions());
        }
        permittedUnproposedExtensionTypes.add(ExtensionType.COOKIE);
        this.autoSelectExtensions(this.chooser.getConfig(), this.chooser.getContext().getTlsContext().getProposedExtensions(), forbiddenExtensionTypes, (ExtensionType[])permittedUnproposedExtensionTypes.toArray(ExtensionType[]::new));
    }

    private void prepareCipherSuite() {
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setSelectedCipherSuite(this.chooser.getConfig().getDefaultSelectedCipherSuite().getByteValue());
        } else {
            CipherSuite selectedSuite = null;
            for (CipherSuite suite : this.chooser.getConfig().getDefaultServerSupportedCipherSuites()) {
                if (!this.chooser.getClientSupportedCipherSuites().contains((Object)suite)) continue;
                selectedSuite = suite;
                break;
            }
            if (selectedSuite == null) {
                selectedSuite = this.chooser.getConfig().getDefaultSelectedCipherSuite();
                LOGGER.warn("No CipherSuites in common, falling back to defaultSelectedCipherSuite");
            }
            this.msg.setSelectedCipherSuite(selectedSuite.getByteValue());
        }
        LOGGER.debug("SelectedCipherSuite: {}", this.msg.getSelectedCipherSuite().getValue());
    }

    private void prepareCompressionMethod() {
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setSelectedCompressionMethod(this.chooser.getConfig().getDefaultSelectedCompressionMethod().getValue());
        } else {
            CompressionMethod selectedCompressionMethod = null;
            for (CompressionMethod method : this.chooser.getConfig().getDefaultServerSupportedCompressionMethods()) {
                if (!this.chooser.getClientSupportedCompressions().contains((Object)method)) continue;
                selectedCompressionMethod = method;
                break;
            }
            if (selectedCompressionMethod == null) {
                selectedCompressionMethod = this.chooser.getConfig().getDefaultSelectedCompressionMethod();
                LOGGER.warn("No CompressionMethod in common, falling back to defaultSelectedCompressionMethod");
            }
            this.msg.setSelectedCompressionMethod(selectedCompressionMethod.getValue());
        }
        LOGGER.debug("SelectedCompressionMethod: {}", this.msg.getSelectedCompressionMethod().getValue());
    }

    private void prepareSessionID() {
        if (this.chooser.getConfig().getHighestProtocolVersion().is13()) {
            this.msg.setSessionId(this.chooser.getClientSessionId());
        } else {
            this.msg.setSessionId(this.chooser.getServerSessionId());
        }
        LOGGER.debug("SessionID: {}", this.msg.getSessionId().getValue());
    }

    private void prepareProtocolVersion() {
        ProtocolVersion ourVersion = this.chooser.getConfig().getHighestProtocolVersion();
        if (this.chooser.getConfig().getHighestProtocolVersion().isTLS13()) {
            ourVersion = ProtocolVersion.TLS12;
        } else if (this.chooser.getConfig().getHighestProtocolVersion().isDTLS13()) {
            ourVersion = ProtocolVersion.DTLS12;
        }
        ProtocolVersion clientVersion = this.chooser.getHighestClientProtocolVersion();
        int intRepresentationOurVersion = ourVersion.getValue()[0] * 256 + ourVersion.getValue()[1];
        int intRepresentationClientVersion = clientVersion.getValue()[0] * 256 + clientVersion.getValue()[1];
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setProtocolVersion(ourVersion.getValue());
        } else if (this.chooser.getHighestClientProtocolVersion().isDTLS() && this.chooser.getConfig().getHighestProtocolVersion().isDTLS()) {
            if (intRepresentationClientVersion <= intRepresentationOurVersion) {
                this.msg.setProtocolVersion(ourVersion.getValue());
            } else {
                this.msg.setProtocolVersion(clientVersion.getValue());
            }
        } else if (!this.chooser.getHighestClientProtocolVersion().isDTLS() && !this.chooser.getConfig().getHighestProtocolVersion().isDTLS()) {
            if (intRepresentationClientVersion >= intRepresentationOurVersion) {
                this.msg.setProtocolVersion(ourVersion.getValue());
            } else {
                this.msg.setProtocolVersion(clientVersion.getValue());
            }
        } else {
            this.msg.setProtocolVersion(this.chooser.getSelectedProtocolVersion().getValue());
        }
        LOGGER.debug("ProtocolVersion: {}", this.msg.getProtocolVersion().getValue());
    }

    protected void prepareEchRandom() {
        ClientHelloMessage innerClientHello = this.chooser.getInnerClientHello();
        byte[] clientRandom = (byte[])innerClientHello.getRandom().getValue();
        byte[] serverRandom = this.chooser.getServerRandom();
        byte[] serverRandomTruncatedPart = Arrays.copyOfRange(serverRandom, serverRandom.length - 8, serverRandom.length);
        byte[] clientHelloInner = this.chooser.getLastClientHello();
        byte[] acceptConfirmation = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] serverHello = this.msg.getSerializer(this.chooser.getContext()).serializeHandshakeMessageContent();
        byte[] type = new byte[]{HandshakeMessageType.SERVER_HELLO.getValue()};
        byte[] length = DataConverter.intToBytes((int)serverHello.length, (int)3);
        serverHello = DataConverter.concatenate((byte[][])new byte[][]{type, length, serverHello});
        int startIndex = HpkeUtil.indexOf(serverHello, serverRandomTruncatedPart);
        System.arraycopy(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, 0, serverHello, startIndex, 8);
        MessageDigestCollector echDigest = new MessageDigestCollector();
        LOGGER.debug("ClientHelloInner: {}", (Object)clientHelloInner);
        LOGGER.debug("ServerHello: {}", (Object)serverHello);
        echDigest.append(clientHelloInner);
        echDigest.append(serverHello);
        LOGGER.debug("Complete resulting digest: {}", (Object)echDigest.getRawBytes());
        byte[] transcriptEchConf = echDigest.digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite());
        LOGGER.debug("Transcript Ech Config: {}", (Object)transcriptEchConf);
        HKDFAlgorithm hkdfAlgorithm = this.chooser.getEchConfig().getHpkeKeyDerivationFunction().getHkdfAlgorithm();
        try {
            byte[] extract = HKDFunction.extract(hkdfAlgorithm, null, clientRandom);
            LOGGER.debug("Extract: {}", (Object)extract);
            acceptConfirmation = HKDFunction.expandLabel(hkdfAlgorithm, extract, label, transcriptEchConf, 8, this.chooser.getSelectedProtocolVersion());
            LOGGER.debug("Accept Confirmation: {}", (Object)acceptConfirmation);
        }
        catch (CryptoException e) {
            LOGGER.warn("Could not calculate accept confirmation");
        }
        byte[] newRandom = DataConverter.concatenate((byte[][])new byte[][]{Arrays.copyOfRange(serverRandom, 0, serverRandom.length - 8), acceptConfirmation});
        this.msg.setRandom(newRandom);
    }
}

