/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.cert;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateEntryPreparator
extends Preparator<CertificateEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateEntry entry;

    public CertificateEntryPreparator(Chooser chooser, CertificateEntry entry) {
        super(chooser, entry);
        this.entry = entry;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing CertificateEntry");
        this.prepareCertificateBytes(this.entry);
        this.prepareCertificateLength(this.entry);
        if (this.entry.getExtensionList() != null) {
            this.prepareExtensions(this.entry);
            this.prepareExtensionLength(this.entry);
        } else {
            this.entry.setExtensionsLength(0);
        }
    }

    private void prepareCertificateBytes(CertificateEntry entry) {
        if (entry.getX509certificate() == null && entry.getX509CerticiateConfig() != null) {
            entry.setCertificateBytes(entry.getX509CerticiateConfig());
        } else if (entry.getX509certificate() != null) {
            entry.setCertificateBytes(entry.getX509certificate().getSerializer(null).serialize());
        } else {
            LOGGER.warn("Unsure how to encode entry. Using new byte[0]");
            entry.setCertificateBytes(new byte[0]);
        }
        LOGGER.debug("Certificate: {}", entry.getCertificateBytes().getValue());
    }

    private void prepareCertificateLength(CertificateEntry entry) {
        entry.setCertificateLength(((byte[])entry.getCertificateBytes().getValue()).length);
        LOGGER.debug("CertificateLength: {}", entry.getCertificateLength().getValue());
    }

    private void prepareExtensions(CertificateEntry entry) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        if (entry.getExtensionList() != null) {
            for (ExtensionMessage extensionMessage : entry.getExtensionList()) {
                ((ExtensionPreparator)extensionMessage.getPreparator(this.chooser.getContext())).prepare();
                stream.write((byte[])extensionMessage.getExtensionBytes().getValue());
            }
            entry.setExtensionBytes(stream.toByteArray());
        }
        LOGGER.debug("ExtensionBytes: {}", entry.getExtensionBytes().getValue());
    }

    private void prepareExtensionLength(CertificateEntry entry) {
        entry.setExtensionsLength(((byte[])entry.getExtensionBytes().getValue()).length);
        LOGGER.debug("ExtensionLength: {}", entry.getExtensionsLength().getValue());
    }
}

