/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurvesExtensionPreparator
extends ExtensionPreparator<EllipticCurvesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EllipticCurvesExtensionMessage msg;

    public EllipticCurvesExtensionPreparator(Chooser chooser, EllipticCurvesExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing EllipticCurvesExtensionMessage");
        this.prepareSupportedGroups(this.msg);
        this.prepareSupportedGroupsLength(this.msg);
    }

    private void prepareSupportedGroups(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroups(this.createNamedGroupsArray());
        LOGGER.debug("SupportedGroups: {}", msg.getSupportedGroups().getValue());
    }

    private byte[] createNamedGroupsArray() {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        List<NamedGroup> namedGroups = this.chooser.getTalkingConnectionEnd() == ConnectionEndType.CLIENT ? this.chooser.getConfig().getDefaultClientNamedGroups() : this.chooser.getConfig().getDefaultServerNamedGroups();
        for (NamedGroup group : namedGroups) {
            stream.write(group.getValue());
        }
        return stream.toByteArray();
    }

    private void prepareSupportedGroupsLength(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroupsLength(((byte[])msg.getSupportedGroups().getValue()).length);
        LOGGER.debug("SupportedGroupsLength: {}", msg.getSupportedGroupsLength().getValue());
    }
}

