/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.constants.EchClientHelloType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedClientHelloExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;

public class EncryptedClientHelloExtensionPreparator
extends ExtensionPreparator<EncryptedClientHelloExtensionMessage> {
    private final EncryptedClientHelloExtensionMessage msg;

    public EncryptedClientHelloExtensionPreparator(Chooser chooser, EncryptedClientHelloExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        if (this.msg.getEchClientHelloType() == EchClientHelloType.OUTER) {
            this.prepareHpkeCipherSuite(this.msg);
            this.prepareConfigId(this.msg);
            this.prepareEnc();
            this.preparePayload();
        }
    }

    @Override
    public void prepareAfterParse() {
    }

    private void prepareConfigId(EncryptedClientHelloExtensionMessage msg) {
        msg.setConfigId(this.chooser.getEchConfig().getConfigId());
    }

    private void prepareEnc() {
        this.msg.setEncLength(this.chooser.getEchClientKeyShareEntry().getPublicKeyLength());
        this.msg.setEnc(this.chooser.getEchClientKeyShareEntry().getPublicKey());
    }

    private void preparePayload() {
        if (this.msg.getPayload() == null) {
            this.msg.setPayload(new byte[0]);
            this.msg.setPayloadLength(0);
        }
    }

    private void prepareHpkeCipherSuite(EncryptedClientHelloExtensionMessage msg) {
        msg.setHpkeCipherSuite(this.chooser.getEchConfig().getHpkeCipherSuites().get(0));
    }
}

