/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.KeyShareEntryPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.KeyShareEntrySerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.KeyShareExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareExtensionPreparator
extends ExtensionPreparator<KeyShareExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final KeyShareExtensionMessage msg;
    private SilentByteArrayOutputStream stream;

    public KeyShareExtensionPreparator(Chooser chooser, KeyShareExtensionMessage message, KeyShareExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing KeyShareExtensionMessage");
        if (this.msg.getKeyShareList() == null) {
            this.msg.setKeyShareList(new LinkedList<KeyShareEntry>());
        }
        this.stream = new SilentByteArrayOutputStream();
        if (this.msg.isRetryRequestMode()) {
            LOGGER.debug("Preparing KeyShareExtension with HelloRetryRequest structure");
            this.msg.setKeyShareList(this.setupRetryRequestKeyShareEntry());
        } else if (this.chooser.getTalkingConnectionEnd() == ConnectionEndType.SERVER) {
            LOGGER.debug("Preparing KeyShareExtension with ServerHello structure");
            this.msg.setKeyShareList(this.setupRegularServerKeyShareEntry());
        }
        if (!this.msg.isRetryRequestMode() && this.msg.getKeyShareList() != null) {
            this.prepareKeyShareEntries();
        }
    }

    private List<KeyShareEntry> setupRegularServerKeyShareEntry() {
        ArrayList<KeyShareEntry> serverList = new ArrayList<KeyShareEntry>();
        List<KeyShareStoreEntry> clientShares = this.chooser.getClientKeyShares();
        for (KeyShareStoreEntry i : clientShares) {
            if (!this.chooser.getServerSupportedNamedGroups().contains((Object)i.getGroup())) continue;
            KeyShareEntry predefinedServerKeyShare = this.getPredefinedKeyShareEntryFromMessage(i.getGroup());
            if (predefinedServerKeyShare != null) {
                LOGGER.debug("Using predefined Key Share Entry for Server Hello");
                serverList.add(predefinedServerKeyShare);
                break;
            }
            KeyShareEntry keyShareEntry = new KeyShareEntry(i.getGroup(), this.chooser.getConfig().getDefaultKeySharePrivateKey(i.getGroup()));
            serverList.add(keyShareEntry);
            break;
        }
        if (serverList.isEmpty()) {
            LOGGER.debug("Client Key Share groups not supported - falling back to default selected group");
            KeyShareEntry keyShareEntry = new KeyShareEntry(this.chooser.getConfig().getDefaultSelectedNamedGroup(), this.chooser.getConfig().getDefaultKeySharePrivateKey(this.chooser.getConfig().getDefaultSelectedNamedGroup()));
            serverList.add(keyShareEntry);
        }
        return serverList;
    }

    private KeyShareEntry getPredefinedKeyShareEntryFromMessage(NamedGroup requiredGroup) {
        if (this.msg.getKeyShareList() != null) {
            for (KeyShareEntry entry : this.msg.getKeyShareList()) {
                if (entry.getGroupConfig() != requiredGroup) continue;
                return entry;
            }
        }
        return null;
    }

    private List<KeyShareEntry> setupRetryRequestKeyShareEntry() {
        ArrayList<KeyShareEntry> serverList = new ArrayList<KeyShareEntry>();
        NamedGroup preferredGroup = this.chooser.getConfig().getDefaultSelectedNamedGroup();
        KeyShareEntry emptyEntry = new KeyShareEntry();
        emptyEntry.setGroup(preferredGroup.getValue());
        emptyEntry.setGroupConfig(preferredGroup);
        serverList.add(emptyEntry);
        this.msg.setKeyShareListBytes(preferredGroup.getValue());
        return serverList;
    }

    private void prepareKeyShareEntries() {
        for (KeyShareEntry entry : this.msg.getKeyShareList()) {
            KeyShareEntryPreparator preparator = new KeyShareEntryPreparator(this.chooser, entry);
            preparator.prepare();
            KeyShareEntrySerializer serializer = new KeyShareEntrySerializer(entry);
            this.stream.write(serializer.serialize());
        }
        this.prepareKeyShareListBytes(this.msg);
        this.prepareKeyShareListLength(this.msg);
    }

    private void prepareKeyShareListBytes(KeyShareExtensionMessage msg) {
        msg.setKeyShareListBytes(this.stream.toByteArray());
        LOGGER.debug("KeyShareListBytes: {}", msg.getKeyShareListBytes().getValue());
    }

    private void prepareKeyShareListLength(KeyShareExtensionMessage msg) {
        msg.setKeyShareListLength(((byte[])msg.getKeyShareListBytes().getValue()).length);
        LOGGER.debug("KeyShareListBytesLength: {}", msg.getKeyShareListLength().getValue());
    }
}

