/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDClearExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDClearExtensionPreparator
extends ExtensionPreparator<PWDClearExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PWDClearExtensionMessage msg;

    public PWDClearExtensionPreparator(Chooser chooser, PWDClearExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing PWDClearExtension");
        this.prepareUsername(this.msg);
        this.prepareUsernameLength(this.msg);
    }

    private void prepareUsername(PWDClearExtensionMessage msg) {
        msg.setUsername(this.chooser.getClientPWDUsername());
        LOGGER.debug("Username: {}", msg.getUsername().getValue());
    }

    private void prepareUsernameLength(PWDClearExtensionMessage msg) {
        msg.setUsernameLength(((String)msg.getUsername().getValue()).length());
        LOGGER.debug("UsernameLength: {}", msg.getUsernameLength().getValue());
    }
}

