/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cryptomator.siv.SivMode;

public class PWDProtectExtensionPreparator
extends ExtensionPreparator<PWDProtectExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PWDProtectExtensionMessage msg;

    public PWDProtectExtensionPreparator(Chooser chooser, PWDProtectExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing PWDProtectExtension");
        try {
            this.prepareUsername(this.msg);
        }
        catch (CryptoException e) {
            throw new PreparationException("Failed to encrypt username", (Throwable)e);
        }
        this.prepareUsernameLength(this.msg);
    }

    private void prepareUsername(PWDProtectExtensionMessage msg) throws CryptoException {
        BigInteger sharedSecret;
        BigInteger clientPublicKey;
        HKDFAlgorithm hkdfAlgorithm;
        Config config = this.chooser.getConfig();
        CyclicGroup group = config.getDefaultPWDProtectGroup().getGroupParameters().getGroup();
        if (!(group instanceof EllipticCurve)) {
            msg.setUsername(new byte[0]);
            LOGGER.debug("Can only compute username for elliptic curves. Using new byte[0] instead");
            return;
        }
        EllipticCurve curve = (EllipticCurve)group;
        Point generator = curve.getBasePoint();
        Point serverPublicKey = config.getDefaultServerPWDProtectPublicKey();
        if (curve.getModulus().bitLength() <= 256) {
            hkdfAlgorithm = HKDFAlgorithm.TLS_HKDF_SHA256;
        } else if (curve.getModulus().bitLength() <= 384) {
            hkdfAlgorithm = HKDFAlgorithm.TLS_HKDF_SHA384;
        } else {
            throw new CryptoException("Missing HKDF algorithm for curves larger than 384 bits");
        }
        Point multedPoint = curve.mult(config.getDefaultServerPWDProtectRandomSecret(), generator);
        if (!multedPoint.isAtInfinity()) {
            clientPublicKey = multedPoint.getFieldX().getData();
        } else {
            LOGGER.warn("Computed intermediate value as point in infinity. Using Zero instead for X value");
            clientPublicKey = BigInteger.ZERO;
        }
        Point sharedPoint = curve.mult(config.getDefaultServerPWDProtectRandomSecret(), serverPublicKey);
        if (!sharedPoint.isAtInfinity()) {
            sharedSecret = curve.mult(config.getDefaultServerPWDProtectRandomSecret(), serverPublicKey).getFieldX().getData();
        } else {
            LOGGER.warn("Computed shared secet as point in infinity. Using Zero instead for X value");
            sharedSecret = BigInteger.ZERO;
        }
        byte[] key = HKDFunction.expand(hkdfAlgorithm, HKDFunction.extract(hkdfAlgorithm, null, DataConverter.bigIntegerToByteArray((BigInteger)sharedSecret)), new byte[0], curve.getModulus().bitLength() / 8);
        LOGGER.debug("Username encryption key: {}", (Object)key);
        byte[] ctrKey = Arrays.copyOfRange(key, 0, key.length / 2);
        byte[] macKey = Arrays.copyOfRange(key, key.length / 2, key.length);
        if (ctrKey.length != 16 && ctrKey.length != 24 && ctrKey.length != 32) {
            LOGGER.warn("PWD ctrkey is of incorrect size. Padding to 16 byte");
            ctrKey = Arrays.copyOf(ctrKey, 16);
        }
        if (macKey.length != 16 && macKey.length != 24 && macKey.length != 32) {
            LOGGER.warn("PWD macKey is of incorrect size. Padding to 16 byte");
            macKey = Arrays.copyOf(macKey, 16);
        }
        SivMode aesSIV = new SivMode();
        byte[] protectedUsername = aesSIV.encrypt(ctrKey, macKey, this.chooser.getClientPWDUsername().getBytes(StandardCharsets.ISO_8859_1), (byte[][])new byte[0][]);
        msg.setUsername(DataConverter.concatenate((byte[][])new byte[][]{DataConverter.bigIntegerToByteArray((BigInteger)clientPublicKey, (int)(curve.getModulus().bitLength() / 8), (boolean)true), protectedUsername}));
        LOGGER.debug("Username: {}", (Object)msg.getUsername());
    }

    private void prepareUsernameLength(PWDProtectExtensionMessage msg) {
        msg.setUsernameLength(((byte[])msg.getUsername().getValue()).length);
        LOGGER.debug("UsernameLength: {}", msg.getUsernameLength().getValue());
    }
}

