/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PSKBinderPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PSKIdentityPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientHelloSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PSKBinderSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PSKIdentitySerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreSharedKeyExtensionPreparator
extends ExtensionPreparator<PreSharedKeyExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PreSharedKeyExtensionMessage msg;
    private ClientHelloMessage clientHello;

    public PreSharedKeyExtensionPreparator(Chooser chooser, PreSharedKeyExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing PreSharedKeyExtensionMessage");
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.msg.getEntries(this.chooser);
            this.prepareLists();
            this.prepareIdentityListBytes();
            this.prepareBinderListBytes();
        } else {
            this.prepareSelectedIdentity();
        }
    }

    private void prepareLists() {
        if (this.msg.getIdentities() != null) {
            for (PSKIdentity pskIdentity : this.msg.getIdentities()) {
                new PSKIdentityPreparator(this.chooser, pskIdentity).prepare();
            }
        }
        if (this.msg.getBinders() != null) {
            for (PSKBinder pskBinder : this.msg.getBinders()) {
                new PSKBinderPreparator(this.chooser, pskBinder).prepare();
            }
        }
    }

    private void prepareSelectedIdentity() {
        LOGGER.debug("Preparing selected identity");
        this.msg.setSelectedIdentity(this.chooser.getContext().getTlsContext().getSelectedIdentityIndex());
    }

    private void prepareIdentityListBytes() {
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        if (this.msg.getIdentities() != null) {
            for (PSKIdentity pskIdentity : this.msg.getIdentities()) {
                PSKIdentitySerializer serializer = new PSKIdentitySerializer(pskIdentity);
                outputStream.write(serializer.serialize());
            }
        } else {
            LOGGER.debug("No PSK available, setting empty identity list");
        }
        this.msg.setIdentityListBytes(outputStream.toByteArray());
        this.msg.setIdentityListLength(((byte[])this.msg.getIdentityListBytes().getValue()).length);
    }

    private void prepareBinderListBytes() {
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        if (this.msg.getBinders() != null) {
            for (PSKBinder pskBinder : this.msg.getBinders()) {
                PSKBinderSerializer serializer = new PSKBinderSerializer(pskBinder);
                outputStream.write(serializer.serialize());
            }
        } else {
            LOGGER.debug("No PSK available, setting empty binder list");
        }
        this.msg.setBinderListBytes(outputStream.toByteArray());
        this.msg.setBinderListLength(((byte[])this.msg.getBinderListBytes().getValue()).length);
    }

    @Override
    public void afterPrepareExtensionContent() {
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.prepareActualBinders();
        }
    }

    private void prepareActualBinders() {
        LOGGER.debug("Preparing binder values to replace dummy bytes");
        ClientHelloSerializer clientHelloSerializer = new ClientHelloSerializer(this.clientHello, this.chooser.getSelectedProtocolVersion());
        byte[] clientHelloBytes = clientHelloSerializer.serialize();
        byte[] relevantBytes = this.getRelevantBytes(clientHelloBytes);
        this.calculateBinders(relevantBytes, this.msg);
        this.prepareBinderListBytes();
    }

    private byte[] getRelevantBytes(byte[] clientHelloBytes) {
        int remainingBytes = clientHelloBytes.length - 2;
        if (this.msg.getBinders() != null) {
            for (PSKBinder pskBinder : this.msg.getBinders()) {
                remainingBytes = remainingBytes - 1 - (Integer)pskBinder.getBinderEntryLength().getValue();
            }
        }
        if (remainingBytes > 0) {
            byte[] relevantBytes = new byte[remainingBytes];
            System.arraycopy(clientHelloBytes, 0, relevantBytes, 0, Math.min(remainingBytes, clientHelloBytes.length));
            LOGGER.debug("Relevant Bytes: {}", (Object)relevantBytes);
            return relevantBytes;
        }
        return new byte[0];
    }

    private void calculateBinders(byte[] relevantBytes, PreSharedKeyExtensionMessage msg) {
        TlsContext tlsContext = this.chooser.getContext().getTlsContext();
        List<PskSet> pskSets = this.chooser.getPskSets();
        if (msg.getBinders() != null) {
            LOGGER.debug("Calculating Binders");
            for (int x = 0; x < msg.getBinders().size(); ++x) {
                try {
                    if (pskSets.size() > x) {
                        HKDFAlgorithm hkdfAlgorithm = AlgorithmResolver.getHKDFAlgorithm(pskSets.get(x).getCipherSuite());
                        Mac mac = Mac.getInstance(hkdfAlgorithm.getMacAlgorithm().getJavaName());
                        DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(ProtocolVersion.TLS13, pskSets.get(x).getCipherSuite());
                        byte[] psk = pskSets.get(x).getPreSharedKey();
                        byte[] earlySecret = HKDFunction.extract(hkdfAlgorithm, new byte[0], psk);
                        byte[] binderKey = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), earlySecret, "res binder", DataConverter.hexStringToByteArray((String)""), tlsContext.getChooser().getSelectedProtocolVersion());
                        byte[] binderFinKey = HKDFunction.expandLabel(hkdfAlgorithm, binderKey, "finished", new byte[0], mac.getMacLength(), tlsContext.getChooser().getSelectedProtocolVersion());
                        byte[] hashBefore = tlsContext.getDigest().getRawBytes();
                        tlsContext.getDigest().setRawBytes(DataConverter.concatenate((byte[][])new byte[][]{hashBefore, relevantBytes}));
                        SecretKeySpec keySpec = new SecretKeySpec(binderFinKey, mac.getAlgorithm());
                        mac.init(keySpec);
                        mac.update(tlsContext.getDigest().digest(ProtocolVersion.TLS13, pskSets.get(x).getCipherSuite()));
                        byte[] binderVal = mac.doFinal();
                        tlsContext.getDigest().setRawBytes(hashBefore);
                        LOGGER.debug("Using PSK: {}", (Object)psk);
                        LOGGER.debug("Calculated Binder: {}", (Object)binderVal);
                        msg.getBinders().get(x).setBinderEntry(binderVal);
                        if (x != 0) continue;
                        tlsContext.setEarlyDataPsk(psk);
                        continue;
                    }
                    LOGGER.warn("Skipping BinderCalculation as Config has not enough PSK sets");
                    continue;
                }
                catch (CryptoException | InvalidKeyException | NoSuchAlgorithmException ex) {
                    throw new PreparationException("Could not calculate Binders", ex);
                }
            }
        } else {
            LOGGER.debug("No PSK dummy binders set, skipping binder computation");
        }
    }

    public ClientHelloMessage getClientHello() {
        return this.clientHello;
    }

    public void setClientHello(ClientHelloMessage clientHello) {
        this.clientHello = clientHello;
    }
}

