/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RecordSizeLimitExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordSizeLimitExtensionPreparator
extends ExtensionPreparator<RecordSizeLimitExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RecordSizeLimitExtensionMessage message;

    public RecordSizeLimitExtensionPreparator(Chooser chooser, RecordSizeLimitExtensionMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    public void prepareExtensionContent() {
        int recordSizeLimit = this.chooser.getConfig().getInboundRecordSizeLimit();
        LOGGER.debug("Preparing RecordSizeLimitExtensionMessage with {}", (Object)recordSizeLimit);
        this.message.setRecordSizeLimit(DataConverter.intToBytes((int)recordSizeLimit, (int)2));
    }
}

