/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNamePairPreparator
extends Preparator<ServerNamePair> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerNamePair pair;

    public ServerNamePairPreparator(Chooser chooser, ServerNamePair pair) {
        super(chooser, pair);
        this.pair = pair;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing ServerNamePairMessage");
        this.prepareServerName(this.pair);
        this.prepareServerNameType(this.pair);
        this.prepareServerNameLength(this.pair);
    }

    private void prepareServerName(ServerNamePair pair) {
        pair.setServerName(pair.getServerNameConfig());
        LOGGER.debug("ServerName: {}", pair.getServerName().getValue());
    }

    private void prepareServerNameType(ServerNamePair pair) {
        pair.setServerNameType(pair.getServerNameTypeConfig());
        LOGGER.debug("ServerNameType: {}", pair.getServerNameType().getValue());
    }

    private void prepareServerNameLength(ServerNamePair pair) {
        pair.setServerNameLength(((byte[])pair.getServerName().getValue()).length);
        LOGGER.debug("ServerNameLength: {}", pair.getServerNameLength().getValue());
    }
}

