/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureAndHashAlgorithmsExtensionPreparator
extends ExtensionPreparator<SignatureAndHashAlgorithmsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SignatureAndHashAlgorithmsExtensionMessage msg;

    public SignatureAndHashAlgorithmsExtensionPreparator(Chooser chooser, SignatureAndHashAlgorithmsExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing SignatureAndHashAlgorithmsExtensionMessage");
        this.prepareSignatureAndHashAlgorithms(this.msg);
        this.prepareSignatureAndHashAlgorithmsLength(this.msg);
    }

    private void prepareSignatureAndHashAlgorithms(SignatureAndHashAlgorithmsExtensionMessage msg) {
        msg.setSignatureAndHashAlgorithms(this.createSignatureAndHashAlgorithmsArray());
        LOGGER.debug("SignatureAndHashAlgorithms: {}", msg.getSignatureAndHashAlgorithms().getValue());
    }

    private byte[] createSignatureAndHashAlgorithmsArray() {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        List<SignatureAndHashAlgorithm> signatureAndHashAlgorithmList = this.chooser.getContext().getTalkingConnectionEndType() == ConnectionEndType.SERVER ? this.chooser.getConfig().getDefaultServerSupportedSignatureAndHashAlgorithms() : this.chooser.getConfig().getDefaultClientSupportedSignatureAndHashAlgorithms();
        for (SignatureAndHashAlgorithm algo : signatureAndHashAlgorithmList) {
            stream.write(algo.getByteValue());
        }
        return stream.toByteArray();
    }

    private void prepareSignatureAndHashAlgorithmsLength(SignatureAndHashAlgorithmsExtensionMessage msg) {
        msg.setSignatureAndHashAlgorithmsLength(((byte[])msg.getSignatureAndHashAlgorithms().getValue()).length);
        LOGGER.debug("SignatureAndHashAlgorithmsLength: " + String.valueOf(msg.getSignatureAndHashAlgorithmsLength().getValue()));
    }
}

