/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfile;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrtpExtensionPreparator
extends ExtensionPreparator<SrtpExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SrtpExtensionMessage msg;

    public SrtpExtensionPreparator(Chooser chooser, SrtpExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        SilentByteArrayOutputStream byteStream = new SilentByteArrayOutputStream();
        if (this.chooser.getTalkingConnectionEnd() == ConnectionEndType.CLIENT) {
            for (SrtpProtectionProfile profile : this.chooser.getConfig().getClientSupportedSrtpProtectionProfiles()) {
                byteStream.write(profile.getByteValue());
            }
        } else {
            byteStream.write(this.chooser.getSelectedSrtpProtectionProfile().getByteValue());
        }
        this.msg.setSrtpProtectionProfiles(byteStream.toByteArray());
        LOGGER.debug("ProtectionProfiles: {}", (Object)this.msg.getSrtpProtectionProfiles());
        this.msg.setSrtpProtectionProfilesLength(((byte[])this.msg.getSrtpProtectionProfiles().getValue()).length);
        LOGGER.debug("ProtectionProfile Length: {} ", this.msg.getSrtpProtectionProfilesLength().getValue());
        this.msg.setSrtpMki(this.chooser.getConfig().getSecureRealTimeTransportProtocolMasterKeyIdentifier());
        LOGGER.debug("MKI: {}", this.msg.getSrtpMki().getValue());
        this.msg.setSrtpMkiLength(((byte[])this.msg.getSrtpMki().getValue()).length);
        LOGGER.debug("MKI Length: {}", this.msg.getSrtpMkiLength().getValue());
    }
}

