/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupportedVersionsExtensionPreparator
extends ExtensionPreparator<SupportedVersionsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SupportedVersionsExtensionMessage msg;

    public SupportedVersionsExtensionPreparator(Chooser chooser, SupportedVersionsExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing SupportedVersionsExtensionMessage");
        this.prepareProtocolVersions(this.msg);
        if (this.chooser.getTalkingConnectionEnd() == ConnectionEndType.CLIENT) {
            this.prepareProtocolVersionsLength(this.msg);
        }
    }

    private void prepareProtocolVersions(SupportedVersionsExtensionMessage msg) {
        msg.setSupportedVersions(this.createProtocolVersionArray());
        LOGGER.debug("SupportedVersions: {}", msg.getSupportedVersions().getValue());
    }

    private void prepareProtocolVersionsLength(SupportedVersionsExtensionMessage msg) {
        msg.setSupportedVersionsLength(((byte[])msg.getSupportedVersions().getValue()).length);
        LOGGER.debug("SupportedVersionsLength: {}", msg.getSupportedVersionsLength().getValue());
    }

    private byte[] createProtocolVersionArray() {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (ProtocolVersion version : this.chooser.getConfig().getSupportedVersions()) {
            stream.write(version.getValue());
        }
        return stream.toByteArray();
    }
}

