/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;

public class TokenBindingExtensionPreparator
extends ExtensionPreparator<TokenBindingExtensionMessage> {
    private final TokenBindingExtensionMessage message;

    public TokenBindingExtensionPreparator(Chooser chooser, TokenBindingExtensionMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    public void prepareExtensionContent() {
        this.message.setTokenBindingVersion(this.chooser.getConfig().getDefaultTokenBindingVersion().getByteValue());
        SilentByteArrayOutputStream tokenbindingKeyParameters = new SilentByteArrayOutputStream();
        for (TokenBindingKeyParameters kp : this.chooser.getConfig().getDefaultTokenBindingKeyParameters()) {
            tokenbindingKeyParameters.write((int)kp.getValue());
        }
        this.message.setTokenBindingKeyParameters(tokenbindingKeyParameters.toByteArray());
        this.message.setParameterListLength(((byte[])this.message.getTokenBindingKeyParameters().getValue()).length);
    }
}

